% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitCalibWeibullRS.R
\name{FitCalibWeibullRS}
\alias{FitCalibWeibullRS}
\title{Fitting Weibull Risk-Set Calibration Models}
\usage{
FitCalibWeibullRS(w, w.res, tm, event, lower = 1e-04, upper = 200)
}
\arguments{
\item{w}{A matrix of time points when measurements on the binary covariate were obtained.}

\item{w.res}{A matrix of measurement results of the binary covariate. Each measurement corresponds to the time points in \code{w}}

\item{tm}{Vector of observed main event time or censoring time.}

\item{event}{Vector of censoring indicators. \code{1} for event \code{0} for censored}

\item{lower}{A value to replace zero in the left point of the interval, Default: 1e-04}

\item{upper}{A value to replace infinity in the right point of the interval, Default: 200}
}
\value{
A 2-column matrix with the shape and scale parameter for each time-point at which a calibration model was fitted.
}
\description{
Fits Weibull risk-set calibration models for time-to-exposure from interval-censored data. The exposure is a binary covariate measured
in intermittent times. This function fits a calibration model at each main event time point, using only members of the risk set at that time point.
}
\details{
In case of an error in the model-fitting at a certain time point, a Weibull calibration 
model is fitted and used for that time point.
}
\examples{
# Simulate data set
sim.data <- ICcalib:::SimCoxIntervalCensSingle(n.sample = 200, lambda = 0.1, 
                                               alpha = 0.25, beta0 = log(0.5), 
                                               mu = 0.2, n.points = 2, 
                                               weib.shape = 1, weib.scale = 2)
# Fit Weibull risk-set calibration models for the conditional covariate 
# starting-time distributions
ICcalib::FitCalibWeibullRS(w = sim.data$w, w.res = sim.data$w.res, 
                           tm = sim.data$obs.tm, event = sim.data$delta)
}
\seealso{
\code{\link[fitdistrplus]{fitdistcens}}, \code{\link[ICcalib]{FitCalibWeibull}}
}
