% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MoransI}
\alias{MoransI}
\title{Efficiently compute Moran's I statistic}
\usage{
MoransI(mat1, r1)
}
\arguments{
\item{mat1}{a matrix of values; NA/Inf values must be coded as NA and are ignored}

\item{r1}{an integer representing the distance (radius), within which nearby
cells are considered neighbours in units of rows/columns}
}
\value{
a single numeric value for Moran's I
}
\description{
Compute Moran's I for a matrix. A fast implementation of Moran's I for
gridded data, with neighbours defined based on a radial distance. Note
that when using radius to define the neighbourhood, a radius of one
corresponds to the rook's neibhourhood. There is currently no
equivalent to queen's neighbourhood.
}
\examples{
(TestMat <- matrix(c(1, 0, 1, 0, 1,
                     0, 1, 0, 1, 0,
                     1, 0, 1, 0, 1,
                     0, 1, 0, 1, 0,
                     1, 0, 1, 0, 1),
                   nrow =5))
# the code below should return -1
MoransI(TestMat, r1 = 1)
}
