% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/justload.R
\name{justload}
\alias{justload}
\title{Loading ILSA data into a list}
\usage{
justload(inputdir, population, justattributes = FALSE)
}
\arguments{
\item{inputdir}{a string indicating the path were ILSA 'SPSS' files are stored.}

\item{population}{a character value indicating which files should be merged. 
For more information on available populations, run \code{ILSAfile.info()} first.}

\item{justattributes}{a logical value indicating if 0 rows should be loaded.
This can be used when we just need to check column attributes. Default is 
\code{FALSE}.}
}
\value{
A list of tibbles.
}
\description{
Load 'SPSS' data from different International Large-Scale Assessments (ILSA),
including: 'TIMSS', 'TIMSS Advanced', 'PIRLS', 'ICCS', 'ICILS', 'CIVED', 'REDS', 'RLII',
and 'SITES' into a list.
}
\examples{
# For example, after downloading 'RLII' 1991 G4 data:

# Downloading 'RLII' 1991 and unzipping files
ILSAdownload(study = "RLII", year = 1991, outputdir = tempdir(), unzip = TRUE, agreeLicense = TRUE)

# Path were raw 'SPSS' files are
input <- file.path(tempdir(),"RLII1991_IDB_SPSS/Data")

# Load only attributes
emptylist <- justload(inputdir = input, population = "ASCt1", justattributes = TRUE)

# Load complete data
fullist <- justload(inputdir = input, population = "ASCt1", justattributes = FALSE)

}
