% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILSAfile.info.R
\name{ILSAfile.info}
\alias{ILSAfile.info}
\title{ILSA data files information}
\usage{
ILSAfile.info(inputdir = getwd())
}
\arguments{
\item{inputdir}{a string indicating the path were ILSA 'SPSS' files are stored.}
}
\value{
A data frame with the number of files and MBs per population.
}
\description{
Aggregates International Large-Scale Assessments (ILSA) data files information by population.
}
\examples{
# Path were raw 'SPSS' files are
input <- system.file("extdata/reds", package = "ILSAmerge")

# Get file information
ILSAfile.info(inputdir = input)

}
