% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ind_ex}
\alias{ind_ex}
\title{Food web indicators of the Central Baltic Sea (Bornholm Basin).}
\format{A data frame with 30 rows and 13 variables. These indicator time series
represent a slight modification of the original time series represented in
Otto et al. (2018).
\describe{
\item{Year}{year given as integer}
\item{TZA}{ln-transformed Total Zooplankton Abundance (in N m^-3^)}
\item{MS}{Mean Size of zooplankton (in wet weight micro grams)}
\item{rCC}{ln-transformed ratio of Cladoceran to Copepod Abundance}
\item{Cops}{ln-transformed Copepod biomass (in mg)}
\item{Micro}{ln-transformed biomass of Microphageous zooplankton (in mg)}
\item{rZPPP}{ratio of Zooplankton to Phytoplankton biomass}
\item{Sprat}{ln-transformed Sprat abundance (in million N)}
\item{Herring}{ln-transformed Herring abundance (in millions N)}
\item{Stickle}{ln-transformed Stickleback CPUE (in kg h^-1^)}
\item{Cod}{ln-transformed Cod CPUE (in kg h^-1^)}
\item{SPF}{ln-transformed Small Predatory Fish (i.e. sprat and herring <10cm) (in million g)}
\item{LPF}{ln-transformed Large Predatory Fish (i.e. Cod >38cm) (in kg h^-1^)}
}}
\usage{
ind_ex
}
\description{
Food web indicators of the Central Baltic Sea (Bornholm Basin).
}
\keyword{datasets}
