% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storedResults.R
\docType{data}
\name{emFeb19811982}
\alias{emFeb19811982}
\title{Ensemble mean sea ice concentration for February 1981-1982 (initialized in November)}
\format{array of dimension of 2 x 304 x 448 (corresponding to year x longitude x 448 latitude)}
\usage{
emFeb19811982
}
\description{
The object \code{emFeb19811982} is an array of the ensemble mean of the predicted sea ice concentration
from the CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model
produced by the National Oceanic and Atmospheric Administration’s Geophysical Fluid Dynamics
Laboratory (Vecchi et al. 2014; Msadek et al. 2014).
The data have been converted to a Polar stereographic grid.
Weights for converting to a polar stereograhic grid were obtained
from the spherical coordinate remapping and interpolation package (SCRIP) (Jones 1997).
}
\examples{
data(emFeb19811982)
dim(emFeb19811982)
}
\references{
Bootstrap sea ice concentration:

Comiso, J., 2000, updated 2015: Bootstrap sea ice concentrations from Nimbus-7 SMMR and
DMSP SSM/I-SSMIS. version 2. \url{http://nsidc.org/data/nsidc-0079}

CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model:

Jones, P.W. "A user’s guide for SCRIP: A spherical coordinate remapping and interpolation package."
Los Alamos National Laboratory, Los Alamos, NM (1997).

Msadek, R., et al.
\href{http://onlinelibrary.wiley.com/doi/10.1002/2014GL060799/full}{"Importance of initial conditions in seasonal predictions of Arctic sea ice extent."}
 Geophysical Research Letters 41.14 (2014): 5208-5215.

National Center for Atmospheric Research, 2017: Earth system grid at NCAR. \url{https://www.
earthsystemgrid.org/home.html}.

Vecchi, Gabriel A., et al.
\href{http://journals.ametsoc.org/doi/abs/10.1175/JCLI-D-14-00158.1}{"On the seasonal forecasting of regional tropical}
cyclone activity." Journal of Climate 27.21 (2014): 7994-8016.
}
\keyword{datasets}
