/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SelectedDenseDoubleMatrix1D;

class SelectedDenseDoubleMatrix2D
extends DoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseDoubleMatrix2D(double[] dArray, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, dArray, 0, 0, 1, 1, nArray, nArray2, n);
    }

    protected SelectedDenseDoubleMatrix2D(int n, int n2, double[] dArray, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = dArray;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    public double[] elements() {
        return this.elements;
    }

    public double getQuick(int n, int n2) {
        return this.elements[this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]];
    }

    public long index(int n, int n2) {
        return this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new DenseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new DenseDoubleMatrix1D(n);
    }

    public void setQuick(int n, int n2, double d) {
        this.elements[this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]] = d;
    }

    public DoubleMatrix1D vectorize() {
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D((int)this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                denseDoubleMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return denseDoubleMatrix1D;
    }

    public DoubleMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedDenseDoubleMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public DoubleMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedDenseDoubleMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D instanceof SelectedDenseDoubleMatrix2D) {
            SelectedDenseDoubleMatrix2D selectedDenseDoubleMatrix2D = (SelectedDenseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == selectedDenseDoubleMatrix2D.elements;
        }
        if (doubleMatrix2D instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == denseDoubleMatrix2D.elements;
        }
        return false;
    }

    protected DoubleMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    protected DoubleMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseDoubleMatrix2D(this.elements, nArray, nArray2, this.offset);
    }
}

