/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.PersistentObject;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix3D;
import cern.colt.matrix.tint.impl.SparseIntMatrix3D;
import cern.jet.math.tint.IntFunctions;

public class IntFactory3D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final IntFactory3D dense = new IntFactory3D();
    public static final IntFactory3D sparse = new IntFactory3D();

    protected IntFactory3D() {
    }

    public IntMatrix3D ascending(int n, int n2, int n3) {
        IntFunctions intFunctions = IntFunctions.intFunctions;
        return this.descending(n, n2, n3).assign(IntFunctions.chain(IntFunctions.neg, IntFunctions.minus(n * n2 * n3)));
    }

    public IntMatrix3D descending(int n, int n2, int n3) {
        IntMatrix3D intMatrix3D = this.make(n, n2, n3);
        int n4 = 0;
        int n5 = n;
        while (--n5 >= 0) {
            int n6 = n2;
            while (--n6 >= 0) {
                int n7 = n3;
                while (--n7 >= 0) {
                    intMatrix3D.setQuick(n5, n6, n7, n4++);
                }
            }
        }
        return intMatrix3D;
    }

    public IntMatrix3D make(int[][][] nArray) {
        if (this == sparse) {
            return new SparseIntMatrix3D(nArray);
        }
        return new DenseIntMatrix3D(nArray);
    }

    public IntMatrix3D make(int n, int n2, int n3) {
        if (this == sparse) {
            return new SparseIntMatrix3D(n, n2, n3);
        }
        return new DenseIntMatrix3D(n, n2, n3);
    }

    public IntMatrix3D make(int n, int n2, int n3, int n4) {
        return this.make(n, n2, n3).assign(n4);
    }

    public IntMatrix3D random(int n, int n2, int n3) {
        return this.make(n, n2, n3).assign(IntFunctions.random());
    }
}

