% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_ProcessResults.R
\name{ProcessResults}
\alias{ProcessResults}
\title{Retrieve significant pairs, based on adjusted p-values.
For each pair that is statistically significant, calculate the
correlation within group1 (e.g. cancer) and the correlation within group2 (e.g.
non-cancer).  Users can then remove pairs with a difference in correlations between
groups 1 and 2 less than a user-defined threshold.}
\usage{
ProcessResults(
  inputResults,
  inputData,
  pvalcutoff = 0.05,
  interactionCoeffPercentile = 0,
  rsquaredCutoff = 0
)
}
\arguments{
\item{inputResults}{IntLimResults object with model results (output of RunIntLim())}

\item{inputData}{MultiDataSet object (output of ReadData()) with analyte levels
and associated meta-data}

\item{pvalcutoff}{cutoff of FDR-adjusted p-value for filtering (default 0.05)}

\item{interactionCoeffPercentile}{percentile cutoff for interaction coefficient 
(default bottom 10 percent (high negative coefficients) and top 10 percent 
(high positive coefficients))}

\item{rsquaredCutoff}{cutoff for lowest r-squared value}
}
\value{
IntResults object with model results (now includes correlations)
}
\description{
Retrieve significant pairs, based on adjusted p-values.
For each pair that is statistically significant, calculate the
correlation within group1 (e.g. cancer) and the correlation within group2 (e.g.
non-cancer).  Users can then remove pairs with a difference in correlations between
groups 1 and 2 less than a user-defined threshold.
}
