% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterVA5.clean.R
\name{DataCheck5}
\alias{DataCheck5}
\title{Data cleaning for InterVA-5 algorithm}
\usage{
DataCheck5(Input, id, probbaseV5, InSilico_check = FALSE, write)
}
\arguments{
\item{Input}{original data vector for one observation coded by 0 (absense), 1 (presence), and NA (missing).}

\item{id}{id for this observation}

\item{probbaseV5}{matrix of probbaseV5}

\item{InSilico_check}{logical indicator for if the check uses InSilicoVA rule. InSilicoVA rule sets all symptoms that should not be asked to missing. In contrast, the default InterVA5 rule sets these symptoms to missing only when they take the substantive value.}

\item{write}{logical indicator of writing to file}
}
\value{
\item{Output }{ new data vector} \item{firstPass
}{ message for the first pass check} \item{secondPass }{ message for the second pass check}
}
\description{
This function implements the data cleaning steps in the InterVA5 software.
}
\examples{

data(RandomVA5)
data(probbaseV5)
probbaseV5 <- as.matrix(probbaseV5)
RandomVA5 <- as.matrix(RandomVA5)
input <- as.character(RandomVA5[1, ])
input[which(toupper(input) == "N")] <- "0" 
input[which(toupper(input) == "Y")] <- "1" 
input[which(input != "1" & input != "0")] <- NA
input <- as.numeric(input)
output <- DataCheck5(Input=input, id="d1", probbaseV5=probbaseV5, write=TRUE)


}
\references{
http://www.interva.net/
}
\seealso{
\code{\link{InterVA5.plot}}
}
\author{
Jason Thomas Zehang Li, Tyler McCormick, Sam Clark
}
\keyword{InterVA}
