% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalData.R
\name{IntervalData}
\alias{IntervalData}
\title{Create an \code{IntervalData} object}
\usage{
IntervalData(a1, a2, type = 1)
}
\arguments{
\item{a1}{a number specifying the infimum or the mid-point of the interval.}

\item{a2}{a number specifying the supremum or the spread of the interval.}

\item{type}{a number specifying the characterisation that is being used.
Only two options are allowed:
\itemize{
\item \code{1}: inf/sup-characterisation is used (default).
\item \code{2}: mid/spr-characterisation is used.
}}
}
\value{
Object of class \code{\linkS4class{IntervalData}}.
}
\description{
For convenience, objects of class \code{IntervalData}
may be created with this function.
}
\examples{
IntervalData(0, 2)
IntervalData(1, 1, 2)

}
\seealso{
Other IntervalData-method: 
\code{\link{IntervalData-class}},
\code{\link{arithmetic}},
\code{\link{as.IntervalData}()},
\code{\link{distance}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{plot}()},
\code{\link{show}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalData-method}
