% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.UPb}
\alias{read.UPb}
\title{Read U-Pb data}
\usage{
read.UPb(fname, format = 1, header = TRUE)
}
\arguments{
\item{fname}{file name (.csv format)}

\item{format}{formatting option, one of either:

1: 'Pb207Pb206','errPb207Pb206', 'Pb206U238','errPb206U238', 'Pb207U235','errPb207U235'}

\item{header}{Boolean flag indicating whether the file contains a header}
}
\description{
Create a 'UPb' object from a .csv file with U-Pb data
}
\examples{
# load one of the built-in .csv files:
fname <- system.file("UPb.csv",package="IsoplotR")
UPb <- read.UPb(fname)
concordia.plot(UPb)
}

