% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedmean.R
\name{weightedmean}
\alias{weightedmean}
\alias{weightedmean.default}
\alias{weightedmean.UPb}
\alias{weightedmean.PbPb}
\alias{weightedmean.ThU}
\alias{weightedmean.ArAr}
\alias{weightedmean.ReOs}
\alias{weightedmean.SmNd}
\alias{weightedmean.RbSr}
\alias{weightedmean.LuHf}
\alias{weightedmean.UThHe}
\alias{weightedmean.fissiontracks}
\title{Calculate the weighted mean age}
\usage{
weightedmean(x, ...)

\method{weightedmean}{default}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, ...)

\method{weightedmean}{UPb}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, type = 4, cutoff.76 = 1100, cutoff.disc = c(-15, 5),
  alpha = 0.05, exterr = TRUE, common.Pb = 0, ...)

\method{weightedmean}{PbPb}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, exterr = TRUE, common.Pb = 1, ...)

\method{weightedmean}{ThU}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, i2i = TRUE, ...)

\method{weightedmean}{ArAr}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, exterr = TRUE, i2i = FALSE, ...)

\method{weightedmean}{ReOs}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, exterr = TRUE, i2i = TRUE, ...)

\method{weightedmean}{SmNd}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, exterr = TRUE, i2i = TRUE, ...)

\method{weightedmean}{RbSr}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, exterr = TRUE, i2i = TRUE, ...)

\method{weightedmean}{LuHf}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, exterr = TRUE, i2i = TRUE, ...)

\method{weightedmean}{UThHe}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, ...)

\method{weightedmean}{fissiontracks}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, exterr = TRUE, ...)
}
\arguments{
\item{x}{a two column matrix of values (first column) and their
standard errors (second column) OR an object of class
\code{UPb}, \code{PbPb}, \code{ArAr}, \code{ReOs}, \code{SmNd},
\code{RbSr}, \code{LuHf}, \code{ThU}, \code{fissiontracks} or
\code{UThHe}}

\item{...}{optional arguments}

\item{detect.outliers}{logical flag indicating whether outliers
should be detected and rejected using Chauvenet's Criterion.}

\item{plot}{logical flag indicating whether the function should
produce graphical output or return numerical values to the
user.}

\item{rect.col}{the fill colour of the rectangles used to show the
measurements or age estimates.}

\item{outlier.col}{if \code{detect.outliers=TRUE}, the outliers are
given a different colour.}

\item{sigdig}{the number of significant digits of the numerical
values reported in the title of the graphical output.}

\item{alpha}{the confidence limits of the error bars/rectangles.}

\item{type}{scalar indicating whether to plot the
\eqn{^{207}}Pb/\eqn{^{235}}U age (\code{type}=1), the
\eqn{^{206}}Pb/\eqn{^{238}}U age (\code{type}=2), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (\code{type}=3), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U age
(\code{type}=4), or the (Wetherill) concordia age (\code{type}=5)}

\item{cutoff.76}{the age (in Ma) below which the
\eqn{^{206}}Pb/\eqn{^{238}}U age and above which the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age is used. This parameter is
only used if \code{type=4}.}

\item{cutoff.disc}{two element vector with the maximum and minimum
percentage discordance allowed between the
\eqn{^{207}}Pb/\eqn{^{235}}U and \eqn{^{206}}Pb/\eqn{^{238}}U
age (if \eqn{^{206}}Pb/\eqn{^{238}}U < \code{cutoff.76}) or
between the \eqn{^{206}}Pb/\eqn{^{238}}U and
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (if
\eqn{^{206}}Pb/\eqn{^{238}}U > \code{cutoff.76}).  Set
\code{cutoff.disc=NA} if you do not want to use this filter.}

\item{exterr}{propagate decay constant uncertainties?}

\item{common.Pb}{apply a common lead correction using one of three
    methods:

\code{1}: use the isochron intercept as the initial Pb-composition

\code{2}: use the Stacey-Kramer two-stage model to infer the initial
Pb-composition

\code{3}: use the Pb-composition stored in
\code{settings('iratio','Pb206Pb204')} and
\code{settings('iratio','Pb207Pb204')}}

\item{i2i}{`isochron to intercept': calculates the initial (aka
`inherited', `excess', or `common')
\eqn{^{40}}Ar/\eqn{^{36}}Ar, \eqn{^{207}}Pb/\eqn{^{204}}Pb,
\eqn{^{87}}Sr/\eqn{^{86}}Sr, \eqn{^{143}}Nd/\eqn{^{144}}Nd,
\eqn{^{187}}Os/\eqn{^{188}}Os or \eqn{^{176}}Hf/\eqn{^{177}}Hf
ratio from an isochron fit. Setting \code{i2i} to \code{FALSE}
uses the default values stored in
\code{settings('iratio',...)}. When applied to data of class
\code{ThU}, setting \code{i2i} to \code{TRUE} applies a
detrital Th-correction.}
}
\value{
Returns a list with the following items:

\describe{

\item{mean}{a three element vector with:

\code{x}: the weighted mean

\code{s[x]}: the standard error of the weighted mean

\code{ci[x]}: the \eqn{100(1-\alpha)\%} confidence interval for
\code{x}

}

\item{disp}{a three-element vector with the (over)dispersion and
the lower and upper half-widths of its \eqn{100(1-\alpha)\%}
confidence interval.}

\item{mswd}{the Mean Square of the Weighted Deviates
(a.k.a. `reduced Chi-square' statistic)}

\item{df}{the number of degrees of freedom of the Chi-square test
for homogeneity (\eqn{df=n-1}, where \eqn{n} is the number of
samples).}

\item{p.value}{the p-value of a Chi-square test with \eqn{df}
degrees of freedom, testing the null hypothesis that the underlying
population is not overdispersed.}

\item{valid}{vector of logical flags indicating which steps are
included into the weighted mean calculation}

\item{plotpar}{list of plot parameters for the weighted mean
diagram}
}
}
\description{
Models the data as a Normal distribution with two sources of
variance.  Estimates the mean and `overdispersion' using the method
of Maximum Likelihood. Computes the MSWD of a Normal fit without
overdispersion. Implements a modified Chauvenet Criterion to detect
and reject outliers. Only propagates the analytical uncertainty
associated with decay constants and \eqn{\zeta} and J-factors after
computing the weighted mean isotopic composition.
}
\details{
Let \eqn{\{t_1, ..., t_n\}} be a set of n age estimates
determined on different aliquots of the same sample, and let
\eqn{\{s[t_1], ..., s[t_n]\}} be their analytical
uncertainties. \code{IsoplotR} then calculates the weighted mean of
these data assuming a Normal distribution with two sources of
variance:

\eqn{t_i \sim N(\mu, \sigma^2 = s[t_i]^2 + \omega^2 )}

where \eqn{\mu} is the mean, \eqn{\sigma^2} is the total variance
and \eqn{\omega} is the 'overdispersion'. This equation can be
solved for \eqn{\mu} and \eqn{\omega} by the method of maximum
likelihood. IsoplotR uses a modified version of Chauvenet's
criterion for outlier detection:

\enumerate{

\item Compute the error-weighted mean (\eqn{\mu}) of the \eqn{n}
age determinations \eqn{t_i} using their analytical uncertainties
\eqn{s[t_i]}

\item For each \eqn{t_i}, compute the probability \eqn{p_i} that
that \eqn{|t-\mu|>|t_i-\mu|} for \eqn{t \sim
N(0,\sqrt{s[t_i]^2+\omega^2) }}

\item Let \eqn{p_j \equiv \min(p_1, ..., p_n)}. If
\eqn{p_j<0.05/n}, then reject the j\eqn{^{th}} date, reduce \eqn{n}
by one (i.e., \eqn{n \rightarrow n-1}) and repeat steps 1 through 3
until the surviving dates pass the third step.  }

If the analtyical uncertainties are small compared to the scatter
between the dates (i.e. if \eqn{\omega \gg s[t]} for all \eqn{i}),
then this generalised algorithm reduces to the conventional
Chauvenet criterion. If the analytical uncertainties are large and
the data do not exhibit any overdispersion, then the heuristic
outlier detection method is equivalent to Ludwig (2003)'s `2-sigma'
method.
}
\examples{
ages <- c(251.9,251.59,251.47,251.35,251.1,251.04,250.79,250.73,251.22,228.43)
errs <- c(0.28,0.28,0.63,0.34,0.28,0.63,0.28,0.4,0.28,0.33)
weightedmean(cbind(ages,errs))

data(examples)
weightedmean(examples$LudwigMean)
}
\seealso{
\code{\link{central}}
}
