% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/york.R
\name{york}
\alias{york}
\title{Linear regression of X,Y-variables with correlated errors}
\usage{
york(x, alpha = 0.05)
}
\arguments{
\item{x}{a 4 or 5-column matrix with the X-values, the analytical
uncertainties of the X-values, the Y-values, the analytical
uncertainties of the Y-values, and (optionally) the correlation
coefficients of the X- and Y-values.}

\item{alpha}{cutoff value for confidence intervals}
}
\value{
A four-element list of vectors containing:

    \describe{

    \item{a}{the intercept of the straight line fit and its
    standard error}

    \item{b}{the slope of the fit and its standard error}

    \item{cov.ab}{the covariance of the slope and intercept}

    \item{mswd}{the mean square of the residuals (a.k.a
    `reduced Chi-square') statistic}

    \item{df}{degrees of freedom of the linear fit \eqn{(2n-2)}}

    \item{p.value}{p-value of a Chi-square value with \code{df}
    degrees of freedom}

    }
}
\description{
Implements the unified regression algorithm of York et al. (2004)
which, although based on least squares, yields results that are
consistent with maximum likelihood estimates of Titterington and
Halliday (1979).
}
\details{
Given n pairs of (approximately) collinear measurements \eqn{X_i}
and \eqn{Y_i} (for \eqn{1 \leq i \leq n}), their uncertainties
\eqn{s[X_i]} and \eqn{s[Y_i]}, and their covariances
cov[\eqn{X_i,Y_i}], the \code{york} function finds the best fitting
straight line using the least-squares algorithm of York et
al. (2004). This algorithm is modified from an earlier method
developed by York (1968) to be consistent with the maximum
likelihood approach of Titterington and Halliday (1979). It
computes the MSWD as a measure of under/overdispersion.
Overdispersed datasets (MSWD>1) can be dealt with in the same three
ways that are described in the documentation of the
\code{\link{isochron}} function.
}
\examples{
X <- c(1.550,12.395,20.445,20.435,20.610,24.900,
       28.530,50.540,51.595,86.51,106.40,157.35)
Y <- c(.7268,.7849,.8200,.8156,.8160,.8322,
       .8642,.9584,.9617,1.135,1.230,1.490)
n <- length(X)
sX <- X*0.01
sY <- Y*0.005
rXY <- rep(0.8,n)
dat <- cbind(X,sX,Y,sY,rXY)
fit <- york(dat)
scatterplot(dat,fit=fit)
}
\references{
Titterington, D.M. and Halliday, A.N., 1979. On the fitting of
parallel isochrons and the method of maximum likelihood. Chemical
Geology, 26(3), pp.183-195.

York, Derek, et al., 2004. Unified equations for the slope,
intercept, and standard errors of the best straight line.  American
Journal of Physics 72.3, pp.367-375.
}
\seealso{
\code{\link{data2york}}, \code{\link{titterington}},
    \code{\link{isochron}}, \code{\link{ludwig}}
}
