% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibfit.R
\name{calibfit}
\alias{calibfit}
\alias{print.CALIBFIT}
\alias{summary.CALIBFIT}
\title{Fit the calibration model}
\usage{
calibfit(data, isofit, verbose = interactive(), control_optim = list())
}
\arguments{
\item{data}{A \var{dataframe} containing the calibration data (see note
below)}

\item{isofit}{The fitted isoscape created by \code{\link{isofit}}}

\item{verbose}{A \var{logical} indicating whether information about the
progress of the procedure should be displayed or not while the function is
running. By default verbose is \var{TRUE} if users use an interactive R
session and \var{FALSE} otherwise.}

\item{control_optim}{A \var{list} to pass information to the argument control
of the optim call (for advanced users only).}
}
\value{
This function returns a \var{list} of class \var{CALIBFIT} containing
the fixed-effect estimates of the calibration function, the covariance of
the fixed effects, the residual variance of the calibration fit, the fitted
calibration model, the original calibration data set with additional
information added during the fit, and the location of the calibration
points as spatial points.
}
\description{
This function fits a model that establishes the relationship between the
isotopic values of organisms (e.g. tissues such as hair, horn, ivory or
feathers) and the isotopic values of their environment (e.g. precipitation).
}
\details{
The calibration model is a linear mixed-effects model (LMM) that fits the
isotopic values of sedentary organisms as a linear function of the isotopic
values in their environment (e.g. precipitation).

This function considers that the isotopic values from the environment (e.g.
from precipitation) at the locations at which organisms were sampled are not
known. The function therefore predicts these isotopic values from the
geostatistical model fitted by the function \code{\link{isofit}}, which is
provided to \code{\link{calibfit}} using the argument \code{isofit}.

The LMM used to fit the calibration function has a simple fixed-effect
structure: an intercept and a slope. The random effect is more complex: it is
normally distributed with mean zero, a certain variance between locations
proportional to the squared fixed slope, and a covariance structure defined
by the prediction covariance matrix of the isoscape model between the
calibration locations. See appendix in Courtiol et al. 2019 for more details.

This function is only needed in the case for which the assignment of
organisms has to be performed within an isoscape that was built using another
source of isotopic values (e.g., precipitation). This implies that if the
isoscape had been fitted using isotopic ratios from sedentary animals, then
this calibration step is not needed.

If source isotopic values are known at the locations where sedentary
organisms were sampled, users should calibrate their data directly using the
function \code{\link[stats]{lm}} by fitting tissue isotopic values as a
function of source isotopic values.
}
\note{
See \code{\link{CalibDataAlien}} to know which variables are needed to
perform the calibration fit and their names.
}
\examples{

## The examples below will only be run if sufficient time is allowed
## You can change that by typing e.g. options_IsoriX(example_maxtime = XX)
## if you want to allow for examples taking up to ca. XX seconds to run
## (so don't write XX but put a number instead!)

if(getOption_IsoriX("example_maxtime") > 30) {

## We prepare the data:
GNIPDataDEagg <- prepsources(data = GNIPDataDE)

## We fit the models for Germany:
GermanFit <- isofit(data = GNIPDataDEagg,
                    mean_model_fix = list(elev = TRUE, lat_abs = TRUE))

## We fit the calibration model:
CalibAlien <- calibfit(data = CalibDataAlien, isofit = GermanFit)

## We display minimal information:
CalibAlien

## We display more information:
summary(CalibAlien)

## We plot the calibration function:
plot(CalibAlien)

## Add other calibrations on the same plot
CalibDataAlien3 <- CalibDataAlien2 <- CalibDataAlien
CalibDataAlien2$sample_value <- rnorm(nrow(CalibDataAlien2),
  mean = CalibDataAlien2$sample_value, sd = 10)
CalibDataAlien3$sample_value <- rnorm(nrow(CalibDataAlien3),
  mean = CalibDataAlien3$sample_value, sd = 10)
CalibAlien2 <- calibfit(data = CalibDataAlien2, isofit = GermanFit)
CalibAlien3 <- calibfit(data = CalibDataAlien3, isofit = GermanFit)
plot(CalibAlien3)
points(CalibAlien)
points(CalibAlien2, pch = 3, col = "green", CI = list(col = "green"))


}

}
\references{
Courtiol A, Rousset F, Rohwäder M, Soto DX, Lehnert L, Voigt CC,
Hobson KA, Wassenaar LI, Kramer-Schadt S (2019). Isoscape computation and
inference of spatial origins with mixed models using the R package IsoriX.
In Hobson KA, Wassenaar LI (eds.), Tracking Animal Migration with Stable
Isotopes, second edition. Academic Press, London.
}
\keyword{models}
\keyword{regression}
