% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_issues.R
\name{sort.IssuesTB}
\alias{sort.IssuesTB}
\title{Sort issues}
\usage{
\method{sort}{IssuesTB}(
  x,
  decreasing = FALSE,
  sorting_variables = list(),
  filtering_factors = list(),
  ...
)
}
\arguments{
\item{x}{a \code{IssuesTB} object.}

\item{decreasing}{logical. Should the sort be increasing or decreasing?}

\item{sorting_variables}{a list containing the quantitative variables to sort
the issues. The filters are applied in the order of the variables supplied.}

\item{filtering_factors}{a list containing constraints for sorting issues by
sub-group in order of priority}

\item{\dots}{Additional arguments related to milestones for the function
\code{simple_sort}.}
}
\value{
a \code{IssuesTB} object sorted.
}
\description{
Sorting issues with some constraint and order on the labels, the title, the
milestones and/or the body.
}
\details{
In the order of the constraints imposed by the \code{filtering_factors}
argument, the function will first filter by constraint. For each constraint,
the function will then sort according to the quantitative variables supplied
in \code{sorting_variables}.

For example, the following call:

\preformatted{
sort(
    x = issues,
    sorting_variables = list(c(object = "milestones", field = "due_on"),
                             c(object = "issues", field = "created_at")),
    filtering_factors = list(list(values = "bug",
                                  fields = "labels",
                                  values_logic_gate = "OR"),
                             list(values = "package", fields = "title")),
    decreasing = TRUE
)
}

will behave as follows:
\itemize{
\item 
\enumerate{
\item It will select all the issues that have "bug" as a label, then sort
them according to the chronological order of milestones (according to
deadlines) and the chronological order of issue creation dates
}
\item 
\enumerate{
\item Among the remaining issues, it will filter the issues that have
\code{"package"} in the title and apply the same sorting.
}
\item 
\enumerate{
\item Finally, among all the remaining issues (not sorted until now), the
function will apply the same sorting.
}
\item 
\enumerate{
\item The function returns the global list of sorted issues.
}
}

The argument filtering_factors is a list of constraint following the same
naming convention as the \code{\link[IssueTrackeR]{filter_issues}}. So the
constraints are represented by named lists with the various arguments (apart
from \code{x}) to the \code{\link[IssueTrackeR]{filter_issues}}
(\code{values}, \code{fields}, \code{fields_logic_gate},
\code{values_logic_gate} and \code{negate}).
}
\examples{

\donttest{
# Get the milestones of the prject
milestones <- get_milestones("online")
write_milestones_to_dataset(milestones)

all_issues <- get_issues(source = "online", verbose = FALSE)
sorted_issues <- sort(
    x = all_issues,
    sorting_variables = list(list(object = "milestones", field = "due_on"),
                             list(object = "issues", field = "created_at")),
    filtering_factors = list(list(values = "bug",
                                  fields = "labels",
                                  values_logic_gate = "OR"),
                             list(values = "package", fields = "title")),
    milestones = milestones
)
}

}
