% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_functions.R
\name{powerLongSurv}
\alias{powerLongSurv}
\title{Power calculation in joint modeling of longitudinal and 
 survival data - k-th Order Trajectories and Unknown Sigma}
\usage{
powerLongSurv(
  N,
  nevents,
  tmedian,
  meantf,
  p,
  t,
  SigmaTheta,
  sigmae_2,
  ordtraj,
  beta = 0,
  alpha = 0.05,
  tol = 1.5e-08
)
}
\arguments{
\item{N}{numeric specifying the total sample size; minimum 20.}

\item{nevents}{numeric specifying the number of events; at least 20 and at 
most N.}

\item{tmedian}{numeric specifying the median survival time; positive}

\item{meantf}{numeric specifying the mean follow-up time; positive and no 
greater than max(t).}

\item{p}{numeric vector of estimated subject proportions with 2,3,... 
measurements, respectively, zero proportions allowed.}

\item{t}{numeric vector of measurement times, distinct positive components; 
same length as \code{p}.}

\item{SigmaTheta}{numeric matrix specifying the covariance matrix Sigma_Theta}

\item{sigmae_2}{numeric specifying the measurement error; positive.}

\item{ordtraj}{integer specifying the order of trajectories, must be less 
the order of Sigma_Theta}

\item{beta}{numeric specifying the effect of the trajectory; default value 0.}

\item{alpha}{numeric, strictly between 0.0 and 1.0, specifying the Type-I 
Error (2-sided), default value 0.05.}

\item{tol}{numeric, For floating point objects x and y, if |x-y| <= tol, x==y. 
Passed to R function all.equal.}
}
\value{
An object of S4 class \code{powerLongSurv},
 which has the following 12 components
 \itemize{
   \item{title }{character string}
   \item{subtitle }{character string}
   \item{t }{numeric vector}
   \item{p }{numeric vector}
   \item{N }{integer}
   \item{nevents }{integer}
   \item{censr }{numeric}
   \item{tmedian }{numeric}
   \item{meantf }{numeric}
   \item{SigmaTheta }{numeric matrix}
   \item{ordtraj }{integer}
   \item{BSigma }{numeric matrix}
   \item{beta }{numeric}
   \item{alpha }{numeric}
   \item{power }{numeric}
}
}
\description{
Compute the power in joint modeling of longitudinal and survival data 
  when the variance-covariance matrix Sigma_Theta is unknown and the 
  trajectories are order k.
 
The function computes power for a one-sided test, either
 \deqn{ H_0: \beta = 0 \quad \mbox{ and } \quad H_{1A}: \beta > 0}{% 
   H_0: \beta = 0  and  H_1A: \beta > 0}
 or 
 \deqn{ H_0: \beta = 0 \quad \mbox{ and } \quad H_{1B}: \beta < 0}{% 
   H_0: \beta = 0  and   H_1B: \beta < 0}
 with Type I error \eqn{\alpha}. The choice of the alternative is 
 determined by the sign of \eqn{\beta}. Negative values for \eqn{\beta} indicate that 
 the alternative hypothesis is \eqn{H_{1B}}, while \eqn{\beta \ge 0} indicates that it is 
 \eqn{H_{1A}}.
 
 It creates a \code{powerLongSurv} object.
}
\details{
The function \code{powerLongSurv} is used to calculate the power in joint 
modeling of longitudinal and survival data.
}
\examples{
 ## Example 1.
 ## **********
 ## Input elements of Sigma_theta in forumula 4.6;
 SigmaTheta <- matrix(c(1.2,0.0,0.0,0.0,0.7,0.0,0.0,0.0,0.8),nrow=3,ncol=3)
 
 N        <-  200; # Total sample size;
 nevents  <-  140; # Number of events;
 tmedian  <-  0.7; # median survival;
 meantf   <-  1.4; # mean follow-up time;
 beta     <-  0.2; # Effect of the trajectory;
 alpha    <-  0.05;# Type-I Error (2-sided);
 sigmae_2 <-  0.09; # measurement error;
 
 ## schedule of measurement;
 t <- c(0.4, 0.8, 1.2, 1.6, 2) ; # maximum 2 year follow-up;
 
 ## Input estimated proportion subjects with 2,3,4,5,6 measurements;
 ## This is \xi in formula 4.6;
 ## The data is obtained from the simulated data for the calculation in table 2;
 p <- c(0.3, 0.4, 0.15, 0.1, 0.05);
 
 ## Input the order of trajectories
 ordtraj <- 1 ## linear trajectories
 
 ## Call function
 ## Linear Trajectories
 pLSl <- powerLongSurv(N, nevents, tmedian, meantf, p, t, SigmaTheta,
                       sigmae_2, ordtraj, beta, alpha=0.05)
 pLSl
 show(pLSl)
 unclass(pLSl)
 
 ## Constant Trajectories
 powerLongSurv(N, nevents, tmedian, meantf, p, t, SigmaTheta, sigmae_2,
               ordtraj=0, beta, alpha=0.05)
 
 ## Quadratic Trajectories
 powerLongSurv(N, nevents, tmedian, meantf, p, t, SigmaTheta, sigmae_2,
               ordtraj=2, beta, alpha=0.05)
 
 ## ***************************************************************************
 
 ## Example 2.
 ## **********
 ## Input elements of Sigma_theta in forumula 4.6;
 SigmaTheta <- matrix(c(1.2,0.0,0.0,0.0,0.7,0.0,0.0,0.0,0.8),nrow=3,ncol=3)
 
 N        <-  200; # Total sample size;
 nevents  <-  140; # Number of events;
 tmedian  <-  0.7; # median survival;
 meantf   <-  1.4; # mean follow-up time;
 beta     <-  0.2; # Effect of the trajectory;
 alpha    <-  0.05;# Type-I Error (2-sided);
 sigmae_2 <-  0.09; # measurement error;
 
 ## schedule of measurement;
 t <- c(0.4, 0.8, 1.2, 1.6);
 
 ## Input estimated proportion subjects with 2,3,4,5,6 measurements;
 ## This is \xi in formula 4.6;
 ## The data is obtained from the simulated data for the calculation in table 2;
 p <- c(0.3, 0.4, 0.2, 0.1);
 
 ## Input the order of trajectories
 ordtraj <- 2 ## quadratic trajectories
 
 ## Call function
 ## Quadratic Trajectories
 pLSq <- powerLongSurv(N,nevents,tmedian,meantf,p,t,SigmaTheta,sigmae_2,ordtraj,beta, alpha = 0.05)
 pLSq
 show(pLSq)
 unclass(pLSq)
 
 ## Constant Trajectories
 powerLongSurv(N, nevents, tmedian, meantf, p, t, SigmaTheta, sigmae_2,
               ordtraj=0, beta, alpha=0.05)
 
 ## Linear Trajectories
 powerLongSurv(N, nevents, tmedian, meantf, p, t, SigmaTheta, sigmae_2,
               ordtraj=1, beta, alpha=0.05)

}
\references{
L. M. Chen, J. G. Ibrahim, and H. Chu. Sample size and power determination
 in joint modeling of longitudinal and survival data.
 Statist. Med. 2011, 30 2295-2309
}
\seealso{
\code{\link{powerLongSurv-class}}, \code{\link{show-methods}}
}
\author{
Emil A. Cornea, Liddy M. Chen, Bahjat F. Qaqish, Haitao Chu, and 
  Joseph G. Ibrahim
}
