% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{getTracksSimilar}
\alias{getTracksSimilar}
\title{Search Jamendo database for a track}
\usage{
getTracksSimilar(track_id, limit = 10,
  client_id = Sys.getenv("JAMENDO_CLIENT_ID"))
}
\arguments{
\item{track_id}{Track ID to seach for}

\item{limit}{Integer to set the number of displayed search results. Maximum value is 200.}

\item{client_id}{Defaults to System Environment variable "JAMENDO_CLIENT_ID"}
}
\value{
Returns a data frame which contains information about a track.
See \url{https://developer.jamendo.com/v3.0/tracks} for more information.
}
\description{
Given the id of a Jamendo track, this function lets you find other similar Jamendo tracks.
}
\examples{
\donttest{
##Examples
 tracks <- getTracksSimilar("114069",limit=3)
}
}
