% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{julia_command}
\alias{julia_command}
\title{Evaluate string commands in julia and (may) invoke the julia display system.}
\usage{
julia_command(cmd, show_value = !endsWith(trimws(cmd, "right"), ";"))
}
\arguments{
\item{cmd}{the command string you want to evaluate in julia.}

\item{show_value}{whether to display julia returning value or not,
the default value is `FALSE` if the `cmd` ends with semicolon
and `TRUE` otherwise.}
}
\description{
\code{julia_command} evaluates string commands in julia
without returning the result back to R.
However, it may evoke julia display system,
see the documentation of the argument `show_value` for more details.
If you need to get the evaluation result in R, you can use
\code{julia_eval}.
}
\examples{

\donttest{ ## julia_setup is quite time consuming
  ## doing initialization and automatic installation of Julia if necessary
  julia_setup(installJulia = TRUE)
  julia_command("a = sqrt(2);")
}

}
