% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MdeFunc.R
\name{Koul2StageMDE}
\alias{Koul2StageMDE}
\title{Performs two-stage minimum distance estimation in linear regression model with autoregressive error.}
\usage{
Koul2StageMDE(Y, X, D, RegIntMeasure, AR_Order, ArIntMeasure)
}
\arguments{
\item{Y}{- Vecotor of response variable in linear regression model.}

\item{X}{- Design matrix of explanatory variable in linear regression model.}

\item{D}{- Weight Matrix. Dimesion of D should match that of X. Default value is X*A where A=(X'*X)^(-1/2).}

\item{RegIntMeasure}{- Measure used in integration for the estimation of regression coefficients. It should be either Lebesgue or degenerate.}

\item{AR_Order}{- Oder of the autoregressive error.}

\item{ArIntMeasure}{- Measure used in the first stage for estimation of autoregressive coefficient of error.}
}
\value{
MDE1stage - The list of the first stage minimum distance estimation result. It contains betahat1stage, residual1stage, and rho1stage.

betahat1stage - The first stage minimum distance estimator of regression coefficient.

residual1stage - Residuals after the first stage minimum distance estimation.

rho1stage - The first stage minimum distance estimator of autoregressive coefficient.

MDE2stage - The list of the second stage minimum distance estimation result. It contains betahat2stage, residual2stage, and rho2stage.

betahat2stage - The second stage minimum distance estimator of regression coefficient.

residual2stage - Residuals after the second stage minimum distance estimation.

rho2stage - The second stage minimum distance estimator of autoregressive coefficient.
}
\description{
Performs two-stage minimum distance estimation in linear regression model with autoregressive error.
}
\examples{
####################
n <- 10
p <- 3
X <- matrix(rnorm(n*p, 5,3), nrow=n, ncol=p)   #### Generate n-by-p design matrix X
beta <- c(-2, 0.3, 1.5)                        #### Generate true beta = (-2, 0.3, 1.5)'
rho  <- 0.4                                    #### True rho = 0.4
eps <- vector(length=n)
xi <- rnorm(n, 0,1)                            #### Generate innovation from N(0,1)
                                              #### Generate autoregressive process or order 1
for(i in 1:n){
 if(i==1){eps[i] <- xi[i]}
 else{eps[i] <- rho*eps[i-1] + xi[i]}
}
Y <- X\%*\%beta + eps
#####################
D <- "default"                                  #### Use the default weight matrix
MDEResult <- Koul2StageMDE(Y,X, "default", "Lebesgue", 1, "Lebesgue")
MDE1stageResult <- MDEResult[[1]]
MDE2stageResult <- MDEResult[[1]]

beta1 <- MDE1stageResult$betahat1stage
residual1 <- MDE1stageResult$residual1stage
rho1 <- MDE1stageResult$rhohat1stage

beta2 <- MDE2stageResult$betahat1stage
residual2 <- MDE1stageResult$residual2stage
rho2 <- MDE2stageResult$rhohat1stage
}
\references{
[1] Koul, H. L (1985). Minimum distance estimation in linear regression with unknown error distributions. Statist. Probab. Lett., 3 1-8.

[2] Koul, H. L (1986). Minimum distance estimation and goodness-of-fit tests in first-order autoregression. Ann. Statist., 14 1194-1213.

[3] Koul, H. L (2002). Weighted empirical process in nonlinear dynamic models. Springer, Berlin, Vol. 166
}
\seealso{
KoulArMde() and KoulLrMde()
}

