% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS.R
\name{package_TS}
\alias{package_TS}
\title{Summarize the Time Series model}
\usage{
package_TS(data, formula, timename, weights, control, rho_dist, eta_dist)
}
\arguments{
\item{data}{\code{data.frame} including [1] the time variable (indicated 
in \code{timename}), [2] the predictor variables (required by
\code{formula}) and [3], the multinomial response variable (indicated in
\code{formula}) as verified by \code{\link{check_timename}} and 
\code{\link{check_formula}}. Note that the response variables should be
formatted as a \code{data.frame} object named as indicated by the 
\code{response} entry in the \code{control} list, such as \code{gamma} 
for a standard TS analysis on LDA output.}

\item{formula}{\code{\link[stats]{formula}} defining the regression between
relationship the change points. Any 
predictor variable included must also be a column in 
\code{data} and any (multinomial) response variable must be a set of
columns in \code{data}, as verified by \code{\link{check_formula}}.}

\item{timename}{\code{character} element indicating the time variable
used in the time series.}

\item{weights}{Optional class \code{numeric} vector of weights for each 
document. Defaults to \code{NULL}, translating to an equal weight for
each document. When using \code{multinom_TS} in a standard LDATS 
analysis, it is advisable to weight the documents by their total size,
as the result of \code{\link[topicmodels]{LDA}} is a matrix of 
proportions, which does not account for size differences among documents.
For most models, a scaling of the weights (so that the average is 1) is
most appropriate, and this is accomplished using \code{document_weights}.}

\item{control}{A \code{list} of parameters to control the fitting of the
Time Series model including the parallel tempering Markov Chain 
Monte Carlo (ptMCMC) controls. Values not input assume defaults set by 
\code{\link{TS_control}}.}

\item{rho_dist}{List of saved data objects from the ptMCMC estimation of
change point locations returned by \code{\link{est_changepoints}}
(unless \code{nchangepoints} is 0, then \code{NULL}).}

\item{eta_dist}{Matrix of draws (rows) from the marginal posteriors of the 
coefficients across the segments (columns), as estimated by
\code{\link{est_regressors}}.}
}
\value{
\code{TS_fit}-class list containing the following elements, many of
  which are hidden for \code{print}ing, but are accessible:
  \describe{
    \item{data}{\code{data} input to the function.}
    \item{formula}{\code{\link[stats]{formula}} input to the function.}
    \item{nchangepoints}{\code{nchangepoints} input to the function.}
    \item{weights}{\code{weights} input to the function.}
    \item{timename}{\code{timename} input to the function.}
    \item{control}{\code{control} input to the function.}
    \item{lls}{Iteration-by-iteration 
               \link[=logLik.multinom_TS_fit]{logLik} values for the
                full time series fit by \code{\link{multinom_TS}}.}
    \item{rhos}{Iteration-by-iteration change point estimates from
                \code{\link{est_changepoints}}.}
    \item{etas}{Iteration-by-iteration marginal regressor estimates from
                \code{\link{est_regressors}}, which have been 
                unconditioned with respect to the change point locations.}
    \item{ptMCMC_diagnostics}{ptMCMC diagnostics, 
                               see \code{\link{diagnose_ptMCMC}}}
    \item{rho_summary}{Summary table describing \code{rhos} (the change
                       point locations), 
                       see \code{\link{summarize_rhos}}.}
    \item{rho_vcov}{Variance-covariance matrix for the estimates of
                     \code{rhos} (the change point locations), see 
                     \code{\link{measure_rho_vcov}}.}
    \item{eta_summary}{Summary table describing \code{ets} (the 
                       regressors), 
                       see \code{\link{summarize_etas}}.}
    \item{eta_vcov}{Variance-covariance matrix for the estimates of
                     \code{etas} (the regressors), see 
                     \code{\link{measure_eta_vcov}}.}
    \item{logLik}{Across-iteration average of log-likelihoods 
                   (\code{lls}).}
    \item{nparams}{Total number of parameters in the full model,
                   including the change point locations and regressors.}
    \item{AIC}{Penalized negative log-likelihood, based on 
                    \code{logLik} and \code{nparams}.}
  }
}
\description{
Calculate relevant summaries for the run of a Time Series
  model within \code{\link{TS}} and package the output as a
  \code{TS_fit}-class object.
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDA_models <- LDA_set(document_term_table, topics = 2)[[1]]
  data <- document_covariate_table
  data$gamma <- LDA_models@gamma
  weights <- document_weights(document_term_table)
  formula <- gamma ~ 1
  nchangepoints <- 1
  control <- TS_control()
  data <- data[order(data[,"newmoon"]), ]
  rho_dist <- est_changepoints(data, formula, nchangepoints, "newmoon", 
                               weights, control)
  eta_dist <- est_regressors(rho_dist, data, formula, "newmoon", weights, 
                             control)
  package_TS(data, formula, "newmoon", weights, control, rho_dist, 
             eta_dist)
}

}
