\name{LEAPFrOG_EM}
\alias{LEAPFrOG_EM}
\title{LEAPFrOG Expectation Maximisation }
\description{Provides estimates of admixture proportions in offspring and ungenotyped parents, using phased data}
\usage{
LEAPFrOG_EM(data,p,chr,alpha=1e-6)
}
\arguments{
\item{data}{2 column matrix of  allele counts, with each row as a SNP. Columns 1 and 2 refer to the 2 haplotypes. Each entry is either 1, 0 or NA.}
\item{p}{Matrix of allele frequencies. Each row corresponds with a SNP. Number of rows must equal length of data. Each column is a population }
\item{chr}{Vector of chromosome identifiers, one for each SNP. Each entry is an integer, 1-22 for the autosomes. If two X chromosomes for a female are being analysed, it should be identified by the number 23.}
\item{alpha}{Convergence tolerance for the EM algorithm. The optimisation will stop when an interation fails to change the parental admixture proportions (total change across all parameters) by this amount}
}
\value{
A  list including elements
\item{m}{ A vector: Admixture proportions (one per population) for the genotyped offspring.}
\item{P1}{ A vector: Admixture proportions (one per population) for parent 'A'.}
\item{P2}{ A vector: Admixture proportions (one per population) for parent 'B'.}
\item{P1se}{ A vector: Standard errors (All populations except the last) foradmixture proportions in parent 'A'.}
\item{P2se}{ A vector: Standard errors (All populations except the last) foradmixture proportions in parent 'A'.}
\item{iterations}{Number of expectation steps performed.}
\item{value}{Value of the likelihood function for the final maximisation step.}
}
\details{
LEAPFrOG_EM requires python to be installed. Only the parental admixture proportions are estimated directly (all except the last population), and therefore standard errors are only reported for these only. 
}
\author{Daniel Crouch & Michael Weale, Department of Medical and Molecular Genetics, King's College London}
\seealso{\code{\link[LEAPFrOG:LEAPFrOG]{LEAPFrOG}},\code{\link[LEAPFrOG:LEAPFrOG_plot]{LEAPFrOG_plot}}
}
