% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OLHD.S2010.R
\name{OLHD.S2010}
\alias{OLHD.S2010}
\title{Orthogonal Latin Hypercube Design}
\usage{
OLHD.S2010(C, r, type = "odd")
}
\arguments{
\item{C}{A positive integer.}

\item{r}{A positive integer.}

\item{type}{Design run size type, and it could be either odd or even. If \code{type} is odd (the default setting), \code{OLHD.S2010} returns an OLHD with run size \code{r2^{C+1}+1}. If \code{type} is even, \code{OLHD.S2010} returns an OLHD with run size \code{r2^{C+1}}.}
}
\value{
If all inputs are logical, then the output will be an orthogonal LHD with the following run size: \code{n=r2^{C+1}+1} or \code{n=r2^{C+1}} and the following factor size: \code{k=2^C}.
}
\description{
\code{OLHD.S2010} returns a \code{r2^{C+1}+1} or \code{r2^{C+1}} by \code{2^C} orthogonal Latin hypercube design generated by the construction method of Sun et al. (2010)
}
\examples{
#create an orthogonal LHD with C=3, r=3, type="odd".
#So n=3*2^4+1=49 and k=2^3=8
OLHD.S2010(C=3,r=3,type="odd")

#create an orthogonal LHD with C=3, r=3, type="even".
#So n=3*2^4=48 and k=2^3=8
OLHD.S2010(C=3,r=3,type="even")

}
\references{
Sun, F., Liu, M.Q., and Lin, D.K. (2010) Construction of orthogonal Latin hypercube designs with flexible run sizes. \emph{Journal of Statistical Planning and Inference}, \strong{140}(11), 3236-3242.
}
