% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_quantile_tests.R
\name{empirical_quantile_one_way}
\alias{empirical_quantile_one_way}
\title{Test the equality of a quantile from an unknown distribution.}
\source{
\itemize{
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Owen. Empirical Likelihood. Chapman & Hall/CRC.
}
}
\usage{
empirical_quantile_one_way(x, Q, fctr, conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector.}

\item{Q}{The quantile. A single numeric number. (.50 is median.)}

\item{fctr}{a factor vector indicating groups.}

\item{conf.level}{overall confidence level of the likelihood intervals. Uses Bonferroni correction.}
}
\value{
An S3 class containing the test statistic, p value, list of likelihood based confidence intervals,
overall confidence level, individual confidence level of each interval and alternative
hypothesis.
}
\description{
Test the equality of a quantile from an unknown distribution.
}
\details{
\itemize{
\item Null: Quantiles are equal. (Q1 = Q2 ... Qk).
\item Alternative: At least one quantile is not equal.
}
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rnorm(75, 1, 1)
fctr <- c(rep(1, 25), rep(2, 25), rep(3, 25))
fctr <- factor(fctr, levels = c("1", "2", "3"))
empirical_quantile_one_way(x, .50, fctr, .95)

# Null is false
set.seed(1)
x <- c(rnorm(25, 1, 1), rnorm(25, 2, 1), rnorm(25, 3, 1))
fctr <- c(rep(1, 25), rep(2, 25), rep(3, 25))
fctr <- factor(fctr, levels = c("1", "2", "3"))
empirical_quantile_one_way(x, .50, fctr, .95)
}
