% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltrccf.R
\name{ltrccf}
\alias{ltrccf}
\title{Fit a LTRC conditional inference forest}
\usage{
ltrccf(
  formula,
  data,
  id,
  mtry = NULL,
  ntree = 100L,
  bootstrap = c("by.sub", "by.root", "by.user", "none"),
  samptype = c("swor", "swr"),
  sampfrac = 0.632,
  samp = NULL,
  na.action = "na.omit",
  stepFactor = 2,
  trace = TRUE,
  applyfun = NULL,
  cores = NULL,
  control = partykit::ctree_control(teststat = "quad", testtype = "Univ", minsplit =
    max(ceiling(sqrt(nrow(data))), 20), minbucket = max(ceiling(sqrt(nrow(data))), 7),
    minprob = 0.01, mincriterion = 0, saveinfo = FALSE)
)
}
\arguments{
\item{formula}{a formula object, with the response being a \code{\link[survival]{Surv}}
object, with form


\code{Surv(tleft, tright, event)}.}

\item{data}{a data frame containing \code{n} rows of
left-truncated right-censored observations.
For time-varying data, this should be
a data frame containing pseudo-subject observations based on the Andersen-Gill
reformulation.}

\item{id}{variable name of subject identifiers. If this is present, it will be
searched for in the \code{data} data frame. Each group of rows in \code{data}
with the same subject \code{id} represents the covariate path through time of
a single subject. If not specified, the algorithm then assumes \code{data}
contains left-truncated and right-censored survival data with time-invariant
covariates.}

\item{mtry}{number of input variables randomly sampled as candidates at each node for
random forest algorithms. The default \code{mtry} is tuned by \code{\link{tune.ltrccf}}.}

\item{ntree}{an integer, the number of the trees to grow for the forest.
\code{ntree = 100L} is set by default.}

\item{bootstrap}{bootstrap protocol.
(1) If \code{id} is present,
the choices are: \code{"by.sub"} (by default) which bootstraps subjects,
\code{"by.root"} which bootstraps pseudo-subjects.
Both can be with or without replacement (by default sampling is without
replacement; see the option \code{perturb} below);
(2) If \code{id} is not specified, it
bootstraps the \code{data} by sampling with or without replacement.
Regardless of the presence of \code{id}, if \code{"none"} is chosen,
\code{data} is not bootstrapped at all, and is used in
every individual tree. If \code{"by.user"} is choosen,
the bootstrap specified by \code{samp} is used.}

\item{samptype}{choices are \code{swor} (sampling without replacement) and
\code{swr} (sampling with replacement). The default action here is sampling
without replacement.}

\item{sampfrac}{a fraction, determining the proportion of subjects to draw
without replacement when \code{samptype = "swor"}. The default value is \code{0.632}.
To be more specific, if \code{id} is present, \code{0.632 * N} of subjects with their
pseudo-subject observations are drawn without replacement (\code{N} denotes the
number of subjects); otherwise, \code{0.632 * n} is the requested size
of the sample.}

\item{samp}{Bootstrap specification when \code{bootstype = "by.user"}.
Array of dim \code{n x ntree} specifying how many times each record appears
in each bootstrap sample.}

\item{na.action}{action taken if the data contains \code{NA}’s. The default
\code{"na.omit"} removes the entire record if any of its entries is
\code{NA} (for x-variables this applies only to those specifically listed
in \code{formula}). See function \code{\link[partykit]{cforest}} for
other available options.}

\item{stepFactor}{at each iteration, \code{mtry} is inflated (or deflated)
by this value, used when \code{mtry} is not specified (see \code{\link{tune.ltrccf}}).
The default value is \code{2}.}

\item{trace}{whether to print the progress of the search of the optimal value of
\code{mtry}, when \code{mtry} is not specified (see \code{\link{tune.ltrccf}}).
\code{trace = TRUE} is set by default.}

\item{applyfun}{an optional \code{lapply}-style function with arguments
\code{function(X, FUN, ...)}.
It is used for computing the variable selection criterion. The default is to use the
basic \code{lapply} function unless the \code{cores} argument is specified (see below).
See \code{\link[partykit]{ctree_control}}.}

\item{cores}{numeric. See \code{\link[partykit]{ctree_control}}.}

\item{control}{a list of control parameters, see \code{\link[partykit]{ctree_control}}.
\code{control} parameters \code{minsplit}, \code{minbucket} have been adjusted from the
\code{\link[partykit]{cforest}} defaults. Other default values correspond to those of the
default values used by \code{\link[partykit]{ctree_control}}.}
}
\value{
An object belongs to the class \code{ltrccf}, as a subclass of
\code{\link[partykit]{cforest}}.
}
\description{
An implementation of the random forest and bagging ensemble algorithms utilizing
LTRC conditional inference trees \code{\link[LTRCtrees]{LTRCIT}} as base learners for
left-truncated right-censored survival data with time-invariant covariates.
It also allows for (left-truncated) right-censored survival data with
time-varying covariates.
}
\details{
This function extends the conditional inference survival forest algorithm in
\code{\link[partykit]{cforest}} to fit left-truncated and right-censored data,
which allow for time-varying covariates.
}
\examples{
#### Example with time-varying data pbcsample
library(survival)
Formula = Surv(Start, Stop, Event) ~ age + alk.phos + ast + chol + edema
## Fit an LTRCCF on the time-invariant data, with mtry tuned with stepFactor = 3.
LTRCCFobj = ltrccf(formula = Formula, data = pbcsample, ntree = 50L, stepFactor = 3)
}
\references{
Andersen, P. and Gill, R. (1982). Cox's regression model for counting
processes, a large sample study. \emph{Annals of Statistics}, \strong{10}, 1100-1120.
}
\seealso{
\code{\link{predictProb}} for prediction and \code{\link{tune.ltrccf}}
for \code{mtry} tuning.
}
