% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICtree.R
\name{ICtree}
\alias{ICtree}
\title{Fit a survival tree for interval-censored survival data}
\usage{
ICtree(Formula, data, Control = partykit::ctree_control())
}
\arguments{
\item{Formula}{A formula object, with the response be a \link[survival]{Surv}
object, with form Surv(time1, time2, type="interval2")}

\item{data}{A data frame contains the variables named in Formula.}

\item{Control}{A list of control parameters, see \link[partykit]{ctree_control}}
}
\value{
An object of class \link[partykit]{party}.
}
\description{
Recursive partition for interval-censored survival data in a
conditional inference framework.
}
\details{
\code{ICtree} returns a \link[partykit]{party} object. This function extends
the conditional inference survival tree algorithm  in \code{\link[partykit]{ctree}}
to fit interval-censored survival data. This function requires the interval package,
which in turn requires the Icens package, which is not available on CRAN. To install
the Icens package, enter the following commands

source("https://bioconductor.org/biocLite.R")

biocLite("Icens")
}
\examples{
library(interval)
library(LTRCtrees)
data(bcos)

## Fit ICtree survival tree
Ctree <- ICtree(Surv(left,right,type="interval2")~treatment, data = bcos)

## Plot the fitted tree
plot(Ctree)

}
\references{
Fu, W. and Simonoff, J.S. (2017). Survival trees for Interval Censored Survival data.
arXiv, URL: https://arxiv.org/abs/1702.07763
}
