% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gap_fbh.R
\name{get_gaps_fbhs}
\alias{get_gaps_fbhs}
\title{Gaps and Fuel layers Base Height (FBH)}
\usage{
get_gaps_fbhs (LAD_profiles, verbose=TRUE)
}
\arguments{
\item{LAD_profiles}{original tree Leaf Area Density (LAD) profile (output of [lad.profile()] function in the \emph{leafR} package.
An object of the class text.}

\item{verbose}{Logical, indicating whether to display informational messages (default is TRUE).}
}
\value{
A data frame giving the height of gaps and fuel layers bases in meters.
}
\description{
This function calculates gaps and fuel layers base height (FBH) as the difference in percentiles between consecutive LAD values along the vertical tree profile (VTP).
Negative differences are linked to gaps and positive differences to fuel base height.
}
\details{
# List of tree metrics:
\itemize{
\item treeID: tree ID with strings and numeric values
\item treeID1: tree ID with only numeric values
\item cbh - Height of the fuel layer base height (m)
\item gap - Height of gap between fuel layers (m)
\item gap_lad: LAD value in the gap height
\item gap_perc - Percentage of LAD in the gap height
\item cbh_lad - LAD value in the fuel base height
\item cbh_perc - Percentage of LAD in the fuel base height
\item max_height - Maximum height of the tree profile
}
}
\examples{
library(magrittr)
library(dplyr)

# LAD profiles derived from normalized ALS data after applying [lad.profile()] function
LAD_profiles <- read.table(system.file("extdata", "LAD_profiles.txt", package = "LadderFuelsR"),
header = TRUE)
LAD_profiles$treeID <- factor(LAD_profiles$treeID)

trees_name1 <- as.character(LAD_profiles$treeID)
trees_name2 <- factor(unique(trees_name1))

metrics_precentile_list1<-list()

for (i in levels(trees_name2)) {
tree1 <- LAD_profiles |> dplyr::filter(treeID == i)
metrics_precentil <- get_gaps_fbhs(tree1, verbose=TRUE)
metrics_precentile_list1[[i]] <- metrics_precentil
}

metrics_all_percentil <- dplyr::bind_rows(metrics_precentile_list1)
metrics_all_percentil$treeID <- factor(metrics_all_percentil$treeID)

# Remove the row with all NA values from the original data frame
# First remove "treeID" and "treeID1" columns
no_treeID <- metrics_all_percentil[, -which(names(metrics_all_percentil) == c("treeID","treeID1"))]

# Check if any row has all NA values
NA_or_zero <- apply(no_treeID, 1, function(row) all(is.na(row) | row == 0))

# Get the row index with all NA values
row_index <- which(NA_or_zero)

# Remove the row with all NA values from the original data frame
if (length(row_index) > 0) {
gap_cbh_metrics <- metrics_all_percentil[-row_index, ]
} else {
gap_cbh_metrics <- metrics_all_percentil
}
}
\author{
Olga Viedma, Carlos Silva and JM Moreno
}
