% Generated by roxygen2 (4.0.2): do not edit by hand
\name{U-utils}
\alias{U-utils}
\alias{dU}
\alias{pU}
\alias{qU}
\alias{rU}
\title{Zero-mean, unit-variance version of standard distributions}
\usage{
dU(u, beta, distname)

pU(u, beta, distname)

qU(p, beta, distname)

rU(n, beta, distname)
}
\arguments{
\item{u}{vector of quantiles.}

\item{beta}{vector; parameter \eqn{\boldsymbol \beta} of the input distribution.
See \code{\link{check_beta}} on how to specify \code{beta} for each distribution.}

\item{distname}{string; name of input distribution; see \code{\link{get_distnames}}.}

\item{p}{vector of probability levels}

\item{n}{number of samples}
}
\value{
\code{dU} evaluates the pdf at \code{y}, \code{pU} evaluates the
cdf, \code{qU} is the quantile function, and \code{rU} generates random
deviates of U.
}
\description{
Density, distribution function, quantile function and random number
generation for the (zero-mean and) unit variance version U of the
(location-)scale family input \eqn{X \sim F_X(x \mid \boldsymbol \beta)} -
see References.

Since the zero-mean, unit-variance (or only unit-variance) version U is one
of the main building blocks of Lambert W \eqn{\times} F distributions, these
functions are wrappers to be used by other functions such as
\code{\link{dLambertW}} or \code{\link{rLambertW}}.
}
\examples{
# a zero-mean, unit variance version of the t_3 distribution.
curve(dU(x, beta = c(1, 1, 3), distname = "t"), -4, 4,
      ylab = "pdf", xlab = "u", main = "student-t \\n zero-mean, unit variance")
# cdf of unit-variance version of an exp(3) -> just an exp(1)
curve(pU(x, beta = 3, distname = "exp"), 0, 4, ylab = "cdf", xlab = "u",
      main = "Exponential \\n unit variance")

# all have variance 1
var(rU(n = 1000, distname = "chisq", beta = 2))
var(rU(n = 1000, distname = "normal", beta = c(3, 3)))
var(rU(n = 1000, distname = "exp", beta = 1))
var(rU(n = 1000, distname = "unif", beta = c(0, 10)))
}
\keyword{datagen}
\keyword{distribution}
\keyword{univar}

