% Generated by roxygen2 (4.0.2): do not edit by hand
\name{normfit}
\alias{normfit}
\title{Visual and statistical Gaussianity check}
\usage{
normfit(data, show.volatility = FALSE, plot = TRUE, pch = 1,
  add.legend = TRUE, seed = sample(1e+06, 1))
}
\arguments{
\item{data}{a numeric vector of data values.}

\item{show.volatility}{logical; if \code{TRUE} the squared (centered) data
and its ACF are also shown. Useful for time series data to see if squares exhibit
dependence (for financial data they typically do); default: \code{FALSE}.}

\item{plot}{Should visual checks (histogram, densities, qqplot, ACF) be plotted?
Default \code{TRUE}; otherwise only hypothesis test results are returned.}

\item{pch}{a vector of plotting characters or symbols; default \code{pch = 1}.}

\item{add.legend}{logical; if \code{TRUE} (default) a legend is placed in
histogram/density plot.}

\item{seed}{optional; if sample size > 5,000, then some normality tests
fail to run.  In this case it uses a subsample of size 5,000.  For replicability,
one can pass a seed.  By default it is a random seed.}
}
\value{
A list with results of 3 normality tests (each of class \code{htest}) and the seed
used for subsampling:
\item{anderson.darling}{Anderson Darling (if \pkg{nortest} package is available),}
\item{shapiro.francia}{Shapiro-Francia (if \pkg{nortest} package is available),}
\item{shapiro.wilk}{Shapiro-Wilk,}
\item{seed}{seed for subsampling (only used if sample size > 5,000).}
}
\description{
Graphical and statistical check if data is Gaussian (3 common Normality
tests, QQ-plots, histograms, etc).

\code{normfit} does not show the autocorrelation function (ACF) estimate for
lag \eqn{0}, since it always equals \eqn{1}. Thus removing it does not
lose any information, but greatly improves the y-axis scale for higher order lags
 (which are usually very small compared to 1).
}
\examples{
y <- rLambertW(n = 1000, theta = list(beta = c(3, 4), gamma = 0.3),
               distname = "normal")
normfit(y)

x <- rnorm(n = 1000)
normfit(x)

# mixture of exponential and normal
normfit(c(rexp(100), rnorm(100, mean = -5)))
}
\references{
Thode Jr., H.C. (2002): \dQuote{Testing for Normality}. Marcel
Dekker, New York.
}
\seealso{
\code{\link[stats]{shapiro.test}} in the \pkg{stats} package;
\code{\link[nortest]{ad.test}}, \code{\link[nortest]{sf.test}} in the \pkg{nortest} package.
}
\keyword{hplot}
\keyword{htest}

