% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NS_par.R
\docType{data}
\name{NS_par}
\alias{NS_par}
\title{North Sea data}
\format{A data frame with 21 rows and 8 variables, including:
\describe{
\item{\code{species_names}}{A numeric or character vector of length \code{nfish} that denotes the names of the species in the model.}
 \item{\code{Linf}}{A numeric vector of length \code{nfish} representing the asymptotic length of each species (cm).}
 \item{\code{W_a}}{A numeric vector of length \code{nfish} representing the parameter \code{a} in the length-weight conversion.}
 \item{\code{W_b}}{A numeric vector of length \code{nfish} representing the parameter \code{b} in the length-weight conversion.}
 \item{\code{k}}{A numeric vector of length \code{nfish} representing the von Bertalanffy growth parameter \code{(1/yr)} for each species.}
 \item{\code{Lmat}}{A numeric vector of length \code{nsc} representing the length at which 50\% of the individuals are mature (cm).}
 \item{\code{a}}{A numeric value representing the density independent part of the hockey-stick recruitment curve.}
 \item{\code{b}}{A numeric value representing the density dependent part of the hockey-stick recruitment curve.}
}}
\usage{
NS_par
}
\description{
Data for the 21 species in the North Sea version of the LeMans model.
}
\references{
Thorpe, R.B., Le Quesne, W.J.F., Luxford, F., Collie, J.S., Jennings, S. (2015). Evaluation and management implications of uncertainty in a multispecies size-structured model of population and community responses to fishing. \emph{Methods in Ecology and Evolution}, 6:49-58.
}
\keyword{datasets}
