% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCBDOneWay.R
\name{RCBDOneWay}
\alias{RCBDOneWay}
\alias{rcbd.oneway}
\title{One-Way Test for Equal Means in RCBD}
\description{
Performs F statistic based one-way test on samples collected in a randomized complete block design.
}
\examples{
t <- pmt(
    "rcbd.oneway", n_permu = 5000
)$test(Table4.4.3)$print()

t$type <- "asymp"
t

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:RCBDTest]{LearnNonparam::RCBDTest}} -> \code{RCBDOneWay}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RCBDOneWay-new}{\code{RCBDOneWay$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RCBDOneWay-new"></a>}}
\if{latex}{\out{\hypertarget{method-RCBDOneWay-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{RCBDOneWay} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RCBDOneWay$new(type = c("permu", "asymp"), n_permu = 10000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{a character string specifying the way to calculate the p-value.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to zero (default) then all permutations are used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{RCBDOneWay} object.
}
}
}
