% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epochs.R
\name{dominant_epoch}
\alias{dominant_epoch}
\title{Determine the dominant epoch/interval of a dataset}
\usage{
dominant_epoch(dataset, Datetime.colname = Datetime)
}
\arguments{
\item{dataset}{A light logger dataset. Needs to be a dataframe.}

\item{Datetime.colname}{The column that contains the datetime. Needs to be a
\code{POSIXct} and part of the dataset.}
}
\value{
A \code{tibble} with one row per group and a column with the
\code{dominant.epoch} as a \code{\link[lubridate:duration]{lubridate::duration()}}. Also a column with the
\code{group.indices}, which is helpful for referencing the \code{dominant.epoch}
across dataframes of equal grouping.
}
\description{
Calculate the dominant epoch/interval of a dataset. The dominant
epoch/interval is the epoch/interval that is most frequent in the dataset.
The calculation is done per group, so that you might get multiple variables.
If two or more epochs/intervals are equally frequent, the first one (shortest
one) is chosen.
}
\examples{
dataset <-
tibble::tibble(Id = c("A", "A", "A", "B", "B", "B"),
              Datetime = lubridate::as_datetime(1) +
                         lubridate::days(c(0:2, 4, 6, 8)))
dataset
#get the dominant epoch by group
dataset \%>\%
dplyr::group_by(Id) \%>\%
dominant_epoch()

#get the dominant epoch of the whole dataset
dataset \%>\%
dominant_epoch()              
}
\seealso{
Other regularize: 
\code{\link{gap_finder}()},
\code{\link{gap_handler}()},
\code{\link{gapless_Datetimes}()}
}
\concept{regularize}
