% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subfunctionsIdentification.R
\name{coelutingFrags}
\alias{coelutingFrags}
\title{Coeluting fragments extraction}
\usage{
coelutingFrags(
  precursors,
  products,
  rttol,
  rawData = data.frame(),
  coelCutoff = 0
)
}
\arguments{
\item{precursors}{candidates data frame. Output of \link{findCandidates}.}

\item{products}{peaklist for MS2 function (MSMS).}

\item{rttol}{rt window in seconds.}

\item{rawData}{raw scans data. Output of \link{dataProcessing} function (MSMS$rawData).}

\item{coelCutoff}{coelution score threshold between parent and fragment ions.
Only applied if rawData info is supplied.}
}
\value{
List of data frames with the coeluting fragments for each candidate.
}
\description{
Given a RT and a list of peaks, this function subsets all coeluting fragments
within a rt windows. It is used by identification functions to extract
coeluting fragments from high energy functions for candidate precursor ions.
}
\examples{
\dontrun{
devtools::install_github("maialba3/LipidMSdata2")

library(LipidMS)
dbs <- assignDB()

MS1 <- LipidMSdata2::msobjectDIAneg$peaklist$MS1
MS1 <- MS1[MS1$isotope \%in\% c("[M+0]"), !colnames(MS1) \%in\% c("isotope", "group")]
MS2 <- LipidMSdata2::msobjectDIAneg$peaklist$MS2[,c("m.z", "RT", "int", "peakID")]
rawData <- rbind(LipidMSdata2::msobjectDIAneg$MS1, LipidMSdata2::msobjectDIAneg$MS2)

candidates <- findCandidates(MS1 = MS1, db = dbs$pgdb, ppm = 10,
rt = c(0, 2000), adducts = c("M-H"), rttol = 10, dbs = dbs,
rawData = rawData, coelCutoff = 0.8)

coelfrags <- coelutingFrags(candidates, MSMS, rttol = 10, rawData = rawData,
coelCutoff = 0.8)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
