% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additionalFunctions.R
\name{plotLipids}
\alias{plotLipids}
\title{Plot informative peaks for lipid annotation}
\usage{
plotLipids(msobject, span = 0.4, ppm = 10, verbose = TRUE)
}
\arguments{
\item{msobject}{annotated msobject.}

\item{span}{smoothing parameter. Numeric value between 0 and 1.}

\item{ppm}{mz tolerance for EIC. If set to 0, the EIC will not be shown.}

\item{verbose}{print information messages.}
}
\value{
msobject with a plots element which contains a list of plots.
Plots on the left side represent raw values while plots on the left are
smoothed or clean scans (MS2 in DDA).
}
\description{
Plot informative peaks for each lipid annotated with idPOS and idNEG (or
similar functions).
}
\details{
Peak intensities are relative to the maximum intensity of each peak
to ease visualization.

Grey lines show the the extracted ion chromatograms for the peaks.
}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
