% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_equiv.R
\name{performance_equiv}
\alias{performance_equiv}
\title{performance_equiv function}
\usage{
performance_equiv(model_a, model_b, test_data, dv_index, t = 0.1, alpha = 0.05)
}
\arguments{
\item{model_a}{logistic regression model \eqn{M_A}}

\item{model_b}{logistic regression model \eqn{M_B}}

\item{test_data}{testing dataset}

\item{dv_index}{column number of the dependent variable}

\item{t}{acceptable tolerance level (defaults to 0.1)}

\item{alpha}{significance level \eqn{\alpha} (defaults to 0.05)}
}
\value{
\describe{
  \item{\code{equivalence}}{Are models \eqn{M_A,M_B} producing equivalent
      Brier scores for the given test data? (boolean)}
  \item{\code{brier_score_ac}}{\eqn{M_A} Brier score on the testing data}
  \item{\code{brier_score_bc}}{\eqn{M_B} Brier score on the testing data}
  \item{\code{diff_sd}}{SD of the Brier differences}
  \item{\code{test_stat_l}}{\eqn{t_L} equivalence boundary for the test}
  \item{\code{test_stat_u}}{\eqn{t_U} equivalence boundary for the test}
  \item{\code{crit_val}}{a level-\eqn{\alpha} critical value for the test}
  \item{\code{delta_B}}{Calculated equivalence parameter}
  \item{\code{p_value_l}}{P-value for \eqn{t_L}}
  \item{\code{p_value_u}}{P-value for \eqn{t_U}}
}
}
\description{
This function takes two logistic regression models \eqn{M_A, M_B},
    test data, significance level \eqn{\alpha} and sensitivity level
    \eqn{\delta_B}. It checks whether the models perform equivalently on the
    test set and returns various figures.
}
