# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Multivariate Periodogram.
#' @description \code{Peri} calculates the periodogram of a multivariate time series.
#' @details Returns an array of dimension \code{c(q,q,floor(T/2))}. 
#' @param X (Txq) data matrix.
#' @examples
#' series<-FI.sim(T=1000,q=2,rho=0.7,d=c(0.4,0.4))
#' peri<-Peri(series)
#' par(mfrow=c(2,2))
#' for(i in 1:2){
#' for(j in 1:2){
#' plot(Re(peri[i,j,]), type="h")
#' lines(Im(peri[i,j,]), col=2)
#' }}
#' @export
Peri <- function(X) {
    .Call('_LongMemoryTS_Peri', PACKAGE = 'LongMemoryTS', X)
}

#' Calculate matrix Lambda_j(d) as part of the spectral density
#' @keywords internal
Lambda_j <- function(q, n, T, d_vec) {
    .Call('_LongMemoryTS_Lambda_j', PACKAGE = 'LongMemoryTS', q, n, T, d_vec)
}

#' Armadillo has trouble inverting complex matrices. This is circumvented by this function.
#' @keywords internal
invert <- function(X) {
    .Call('_LongMemoryTS_invert', PACKAGE = 'LongMemoryTS', X)
}

#' @title Estimation of G matrix for multivariate long memory processes.
#' @description \code{G.hat} Estimates the matrix G of a multivariate long memory process 
#'              based on an estimate of the vector of memory parameters. The assumed spectral 
#'              density is that of Shimotsu (2007).
#' @param peri cube containing the periodogram of the multivariate process X.
#' @param Lambda_cube  cube containing the Lambda matrices.
#' @param d_vec q-dimensional data vector.
#' @param m bandwith parameter specifying the number of Fourier frequencies
#' used for the estimation usually \code{floor(1+T^delta)}, where 0<delta<1.
#' @param q dimension of the process.
#' @references Shimotsu, K. (2007): Gaussian semiparametric estimation of multivariate
#' fractionally integrated processes. Journal of Econometrics, Vol. 137, No. 2, pp. 277 - 310.
#' @keywords internal
G_hat_cpp <- function(peri, Lambda_cube, d_vec, m, l, q) {
    .Call('_LongMemoryTS_G_hat_cpp', PACKAGE = 'LongMemoryTS', peri, Lambda_cube, d_vec, m, l, q)
}

#' Profiled Likelihood for GSE
#' @keywords internal
R_d_multi_GSE <- function(d_vec, PERI, m, l, T, q) {
    .Call('_LongMemoryTS_R_d_multi_GSE', PACKAGE = 'LongMemoryTS', d_vec, PERI, m, l, T, q)
}

#' Profiled Likelihood for GSE under Cointegration
#' @keywords internal
R_d_multi_GSE_coint <- function(theta_vec, PERI, m, l, T, q, elements) {
    .Call('_LongMemoryTS_R_d_multi_GSE_coint', PACKAGE = 'LongMemoryTS', theta_vec, PERI, m, l, T, q, elements)
}

#' @title Helper function for MLWS test for multivariate spurious long memory.
#' @description Multivariate local Whittle Score type test for the null hypothesis of true long
#'              memory against the alternative of spurious long memory suggested by Sibbertsen, 
#'              Leschinski and Holzhausen (2015).
#' @details
#' add details here
#' @param X data matrix
#' @param d_vec estimated vector of memory parameters.
#' @param m bandwith parameter specifying the number of Fourier frequencies used 
#' for the estimation usually \code{floor(1+T^delta)}, where 0.5<delta<0.8 for consistency.
#' @param epsilon trimming parameter \code{epsilon=0.05} by default. Determines
#' minimum number of Fourier frequencies used in test statistic. For T>500 it is recommended 
#' to use \code{epsilon=0.02}. Confer Sibbertsen, Leschinski, Holzhausen (2015) for further details.
#' @param eta weight vector.
#' @references Sibbertsen, P., Leschinski, C. H., Holzhausen, M., (2015): A Multivariate Test 
#'              Against Spurious Long Memory. Hannover Economic Paper.
#' @export
W_multi <- function(X, d_vec, m, epsilon, eta) {
    .Call('_LongMemoryTS_W_multi', PACKAGE = 'LongMemoryTS', X, d_vec, m, epsilon, eta)
}

#' @title Helper function that returns AR-representation of FI(d)-process.
#' @description returns the first \code{n} coefficients in the AR-infinity representation
#' of an FI(d) process
#' @param n number of coefficients to be returned
#' @param d memory parameter 
#' @export
ddiffw <- function(n, d) {
    .Call('_LongMemoryTS_ddiffw', PACKAGE = 'LongMemoryTS', n, d)
}

#' calculate residuals
#' @inheritParams ll.VARFIMA
#' @keywords internal
ll_inner <- function(data, pre_sample, T, d_vec, phi, THETA, q, approx) {
    .Call('_LongMemoryTS_ll_inner', PACKAGE = 'LongMemoryTS', data, pre_sample, T, d_vec, phi, THETA, q, approx)
}

#' some comment
#' @keywords internal
cumsumcpp <- function(input) {
    .Call('_LongMemoryTS_cumsumcpp', PACKAGE = 'LongMemoryTS', input)
}

#' some comment
#' @keywords internal
repcx <- function(num, q) {
    .Call('_LongMemoryTS_repcx', PACKAGE = 'LongMemoryTS', num, q)
}

#' some comment
#' @keywords internal
simone <- function(G, eta, epsilon, T) {
    .Call('_LongMemoryTS_simone', PACKAGE = 'LongMemoryTS', G, eta, epsilon, T)
}

#' some comment
#' @title simulate limit distribution of test statistic
#' @keywords internal
simMLWS <- function(G, eta, epsilon, T, M) {
    .Call('_LongMemoryTS_simMLWS', PACKAGE = 'LongMemoryTS', G, eta, epsilon, T, M)
}

