% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_plot.R
\name{community_plot}
\alias{community_plot}
\title{Generate Community Composition Plot Based on Tax_summary Object}
\usage{
community_plot(
  taxobj,
  taxlevel,
  n = 10,
  palette = "Spectral",
  nrow = NULL,
  rmprefix = NULL
)
}
\arguments{
\item{taxobj}{Taxonomy summary objects generated by \code{\link{tax_summary}}.}

\item{taxlevel}{Character. taxonomy levels used for visualization.Must be one of c("Domain","Phylum","Class","Order","Family","Genus","Species","Base").}

\item{n}{Numeric. Top n taxa remained according to relative abundance. Default:10}

\item{palette}{Character. Palette for visualization,default:"Spectral",recommended to use "Paired" for more than 15 tax.}

\item{nrow}{Numeric. Number of rows when wrap panels,default:NULL.}

\item{rmprefix}{Numeric. Removed prefix character in taxonomy annotation.Default:NULL. See details in example.}
}
\value{
community_plot2 returns three ggplot objects, two data frame used in visualization and one character of filled mapping colors
}
\description{
Microbial community composition visualization in format of barplot, areaplot and alluvialplot
}
\examples{
{
  require(magrittr)
  ### Data preparation ###
  data("Two_group")

  ## Use taxonomy summary objects
  phylum10 <- community_plot(
    taxobj = Two_group,
    taxlevel = "Phylum",
    n = 10,
    rmprefix = "p__"
  )

  phylum10$barplot  # Check bar plot
  phylum10$areaplot  # Check area plot
  phylum10$alluvialplot  # Check alluvial plot

  phylum10$Top10Phylum \%>\% head(10)  # Check top taxa data frame
  phylum10$Grouped_Top10Phylum \%>\% head(10)  # Check grouped top taxa data frame
  print(phylum10$filled_color)  # Check mapping colors

  # Double facet
  data("Facet_group")

  # Using palette by default
  phylum10 <- community_plot(
    taxobj = Facet_group,
    taxlevel = "Phylum",
    n = 10,
    rmprefix = " p__"
  )
  phylum10$barplot
  phylum10$areaplot
  phylum10$alluvialplot

  # Another example
  genus20 <- community_plot(
    taxobj = Facet_group,
    taxlevel = "Genus",
    n = 20,
    palette = "Paired",
    rmprefix = " g__"
  )
  genus20$alluvialplot
}
}
\author{
Wang Ningqi\href{mailto:2434066068@qq.com}{2434066068@qq.com}
}
