% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LR-predict.R
\name{predict.LR}
\alias{predict.LR}
\alias{predict.LR_boot}
\alias{fitted.LR}
\alias{fitted.LR_boot}
\title{Prediction and fitted values for the Lorenz regression}
\usage{
\method{predict}{LR}(object, newdata, type = c("index", "response"), ...)

\method{fitted}{LR}(object, type = c("index", "response"), ...)
}
\arguments{
\item{object}{An object of class \code{"LR"}.}

\item{newdata}{An optional data frame in which to look for variables with which to predict. If omitted, the original data are used.}

\item{type}{A character string indicating the type of prediction or fitted values. Possible values are \code{"response"} and \code{"index"} (the default).
In the first case, the prediction estimates the conditional expectation of the response given the covariates.
In the second case, the prediction estimates only the index of the single-index model.}

\item{...}{Additional arguments passed to the function \code{\link{Rearrangement.estimation}}.}
}
\value{
A vector of predictions for \code{predict}, or a vector of fitted values for \code{fitted}.
}
\description{
\code{prediction} provides predictions for an object of class \code{"LR"},
while \code{fitted} extracts the fitted values.
}
\details{
If \code{type="response"}, the link function of the single-index model must be estimated. This is done via the function \code{\link{Rearrangement.estimation}}.
}
\examples{
## For examples see example(Lorenz.Reg) and example(Lorenz.boot)

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link{Rearrangement.estimation}}
}
