% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_Reader.R
\name{create_Reader}
\alias{create_Reader}
\title{Function to create a Reader.}
\usage{
create_Reader(name, description, stimulation, filterStack, PMT)
}
\arguments{
\item{name}{\link{character}: Name of the Reader.}

\item{description}{\link{character}: Description of the Reader.}

\item{stimulation}{\link{numeric}: Excitation source of the Reader.}

\item{filterStack}{\link{numeric}: filter stack of the Reader.}

\item{PMT}{\link{numeric}: PMT of the Reader.}
}
\value{
This function return a new Reader.
}
\description{
This function create a new Reader.
}
\examples{
# Data
name <- 'example'
description <- 'example'

# Create reader components
filter <- default_Filters('example')
filterStack <- create_FilterStack(name, description, filter)
stimulation <- default_Stimulation('example')
PMT <- default_PMT('example')

reader <- create_Reader(name, description, stimulation, filterStack, PMT)

plot_Reader(reader)

}
\author{
David Strebler, University of Cologne (Germany).
}

