% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_GrowthCurve.R
\name{plot_GrowthCurve}
\alias{plot_GrowthCurve}
\title{Fit and plot a growth curve for luminescence data (Lx/Tx against dose)}
\usage{
plot_GrowthCurve(sample, na.rm = TRUE, mode = "regenerative",
  fit.method = "EXP", fit.force_through_origin = FALSE,
  fit.weights = TRUE, fit.includingRepeatedRegPoints = TRUE,
  fit.NumberRegPoints = NULL, fit.NumberRegPointsReal = NULL,
  fit.bounds = TRUE, NumberIterations.MC = 100, output.plot = TRUE,
  output.plotExtended = TRUE, output.plotExtended.single = FALSE,
  cex.global = 1, txtProgressBar = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{sample}{\code{\link{data.frame}} (\bold{required}): data frame with
three columns for x=Dose,y=LxTx,z=LxTx.Error, y1=TnTx. The column for the
test dose response is optional, but requires 'TnTx' as column name if used. For exponential
fits at least three dose points (including the natural) should be provided.}

\item{na.rm}{\code{\link{logical}} (with default): excludes \code{NA} values
from the data set prior to any further operations.}

\item{mode}{\code{\link{character}} (with default): selects calculation mode of the function.
(A) \code{"regenerative"} (default) calculates the De by assuming a regenative curve,
(B) \code{"additive"} calculates de De by assuming an additive curve and
(C) \code{"alternate"} calculates no De and just fits the data points. Please note that
for option \code{"regenrative"} the first point is considered as natural dose}

\item{fit.method}{\code{\link{character}} (with default): function used for
fitting. Possible options are: \code{LIN}, \code{QDR}, \code{EXP}, \code{EXP OR LIN},
\code{EXP+LIN} or \code{EXP+EXP}. See details.}

\item{fit.force_through_origin}{\code{\link{logical}} (with default) allow to force
the fitted function through the origin. For \code{method = "EXP+EXP"} the function will
go to the origin in either case, so this option will have no effect.}

\item{fit.weights}{\code{\link{logical}} (with default): option whether the
fitting is done with or without weights. See details.}

\item{fit.includingRepeatedRegPoints}{\code{\link{logical}} (with default):
includes repeated points for fitting (\code{TRUE}/\code{FALSE}).}

\item{fit.NumberRegPoints}{\code{\link{integer}} (optional): set number of
regeneration points manually. By default the number of all (!) regeneration
points is used automatically.}

\item{fit.NumberRegPointsReal}{\code{\link{integer}} (optional): if the
number of regeneration points is provided manually, the value of the real,
regeneration points = all points (repeated points) including reg 0, has to
be inserted.}

\item{fit.bounds}{\code{\link{logical}} (with default): set lower fit bounds
for all fitting parameters to 0. Limited for the use with the fit methods
\code{EXP}, \code{EXP+LIN} and \code{EXP OR LIN}. Argument to be inserted
for experimental application only!}

\item{NumberIterations.MC}{\code{\link{integer}} (with default): number of
Monte Carlo simulations for error estimation. See details.}

\item{output.plot}{\code{\link{logical}} (with default): plot output
(\code{TRUE/FALSE}).}

\item{output.plotExtended}{\code{\link{logical}} (with default): If
\code{TRUE}, 3 plots on one plot area are provided: (1) growth curve, (2)
histogram from Monte Carlo error simulation and (3) a test dose response
plot. If \code{FALSE}, just the growth curve will be plotted.
\bold{Requires:} \code{output.plot = TRUE}.}

\item{output.plotExtended.single}{\code{\link{logical}} (with default):
single plot output (\code{TRUE/FALSE}) to allow for plotting the results in
single plot windows. Requires \code{output.plot = TRUE} and
\code{output.plotExtended = TRUE}.}

\item{cex.global}{\code{\link{numeric}} (with default): global scaling
factor.}

\item{txtProgressBar}{\code{\link{logical}} (with default): enables or disables txtProgressBar.
If \code{verbose = FALSE} also no txtProgressBar is shown.}

\item{verbose}{\code{\link{logical}} (with default): enables or disables terminal feedback.}

\item{\dots}{Further arguments and graphical parameters to be passed. Note:
Standard arguments will only be passed to the growth curve plot. Supported:
\code{xlim}, \code{ylim}, \code{main}, \code{xlab}, \code{ylab}}
}
\value{
Along with a plot (so far wanted) an \code{RLum.Results} object is returned containing,
the slot \code{data} contains the following elements:\cr

\tabular{lll}{
\bold{DATA.OBJECT} \tab \bold{TYPE} \tab \bold{DESCRIPTION} \cr
\code{..$De} : \tab  \code{data.frame} \tab Table with De values \cr
\code{..$De.MC} : \tab \code{numeric} \tab Table with De values from MC runs \cr
\code{..$Fit} : \tab \code{\link{nls}} or \code{\link{lm}} \tab object from the fitting for \code{EXP},
\code{EXP+LIN} and \code{EXP+EXP}. In case of a resulting  linear fit when using \code{LIN}, \code{QDR} or
\code{EXP OR LIN} \cr
\code{..$Formula} : \tab \code{\link{expression}} \tab Fitting formula as R expression \cr
\code{..$call} : \tab \code{call} \tab The original function call\cr
}
}
\description{
A dose response curve is produced for luminescence measurements using a
regenerative protocol.
}
\details{
\bold{Fitting methods} \cr\cr For all options (except for the \code{LIN}, \code{QDR} and
the \code{EXP OR LIN}), the \code{\link[minpack.lm]{nlsLM}} function with the
\code{LM} (Levenberg-Marquardt algorithm) algorithm is used. Note: For historical reasons
for the Monte Carlo simulations partly  the function \code{\link{nls}} using the \code{port} algorithm.

The solution is found by transforming the function or using \code{\link{uniroot}}. \cr

\code{LIN}: fits a linear function to the data using
\link{lm}: \deqn{y = m*x+n}

\code{QDR}: fits a linear function to the data using
\link{lm}: \deqn{y = a + b * x + c * x^2}

\code{EXP}: try to fit a function of the form
\deqn{y = a*(1-exp(-(x+c)/b))} Parameters b and c are approximated by a
linear fit using \link{lm}. Note: b = D0\cr

\code{EXP OR LIN}: works for some cases where an \code{EXP} fit fails. If
the \code{EXP} fit fails, a \code{LIN} fit is done instead. \cr

\code{EXP+LIN}: tries to fit an exponential plus linear function of the
form: \deqn{y = a*(1-exp(-(x+c)/b)+(g*x))} The De is calculated by
iteration.\cr \bold{Note:} In the context of luminescence dating, this
function has no physical meaning. Therefore, no D0 value is returned.\cr

\code{EXP+EXP}: tries to fit a double exponential function of the form
\deqn{y = (a1*(1-exp(-(x)/b1)))+(a2*(1-exp(-(x)/b2)))} This fitting
procedure is not robust against wrong start parameters and should be further
improved.\cr\cr

\bold{Fit weighting}\cr

If the option \code{fit.weights =  TRUE} is chosen, weights are calculated using
provided signal errors (Lx/Tx error): \deqn{fit.weights = 1/error/(sum(1/error))}\cr

\bold{Error estimation using Monte Carlo simulation}\cr

Error estimation is done using a Monte Carlo (MC) simulation approach. A set of Lx/Tx values is
constructed by randomly drawing curve data from samled from normal
distributions. The normal distribution is defined by the input values (mean
= value, sd = value.error). Then, a growth curve fit is attempted for each
dataset resulting in a new distribution of single De values. The \link{sd}
of this distribution is becomes then the error of the De. With increasing
iterations, the error value becomes more stable. \bold{Note:} It may take
some calculation time with increasing MC runs, especially for the composed
functions (\code{EXP+LIN} and \code{EXP+EXP}).\cr Each error estimation is
done with the function of the chosen fitting method. \cr

\bold{Subtitle information}\cr

To avoid plotting the subtitle information, provide an empty user mtext \code{mtext = ""}.
To plot any other subtitle text, use \code{mtext}.
}
\section{Function version}{
 1.9.3 (2017-01-24 21:10:47)
}

\examples{

##(1) plot growth curve for a dummy data.set and show De value
data(ExampleData.LxTxData, envir = environment())
temp <- plot_GrowthCurve(LxTxData)
get_RLum(temp)

##(1a) to access the fitting value try
get_RLum(temp, data.object = "Fit")

##(2) plot the growth curve only - uncomment to use
##pdf(file = "~/Desktop/Growth_Curve_Dummy.pdf", paper = "special")
plot_GrowthCurve(LxTxData)
##dev.off()

##(3) plot growth curve with pdf output - uncomment to use, single output
##pdf(file = "~/Desktop/Growth_Curve_Dummy.pdf", paper = "special")
plot_GrowthCurve(LxTxData, output.plotExtended.single = TRUE)
##dev.off()

##(4) plot resulting function for given intervall x
x <- seq(1,10000, by = 100)
plot(
 x = x,
 y = eval(temp$Formula),
 type = "l"
)

##(5) plot using the 'additive' mode
LxTxData[1,2:3] <- c(0.5, 0.001)
print(plot_GrowthCurve(LxTxData,mode = "additive"))

##(6) plot using the 'alternate' mode
LxTxData[1,2:3] <- c(0.5, 0.001)
print(plot_GrowthCurve(LxTxData,mode = "alternate"))

}
\seealso{
\code{\link{nls}}, \code{\linkS4class{RLum.Results}},
\code{\link{get_RLum}}, \code{\link[minpack.lm]{nlsLM}}, \code{\link{lm}}, \code{uniroot}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France), \cr Michael Dietze, GFZ Potsdam (Germany)
\cr R Luminescence Package Team} 

\section{How to cite}{
Kreutzer, S., Dietze, M. (2017). plot_GrowthCurve(): Fit and plot a growth curve for luminescence data (Lx/Tx against dose). Function version 1.9.3. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.1. https://CRAN.R-project.org/package=Luminescence
}

