% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_FuchsLang2001.R
\name{calc_FuchsLang2001}
\alias{calc_FuchsLang2001}
\title{Apply the model after Fuchs & Lang (2001) to a given De distribution.}
\usage{
calc_FuchsLang2001(data, cvThreshold = 5, startDeValue = 1, plot = TRUE, ...)
}
\arguments{
\item{data}{\linkS4class{RLum.Results} or \link{data.frame} (\strong{required}):
for \link{data.frame}: two columns with De \code{(data[,1])} and De error \code{(values[,2])}}

\item{cvThreshold}{\link{numeric} (\emph{with default}):
coefficient of variation in percent, as threshold for the method,
e.g. \code{cvThreshold = 3}. See details
.}

\item{startDeValue}{\link{numeric} (\emph{with default}):
number of the first aliquot that is used for the calculations}

\item{plot}{\link{logical} (\emph{with default}):
plot output \code{TRUE}/\code{FALSE}}

\item{...}{further arguments and graphical parameters passed to \link{plot}}
}
\value{
Returns a plot (\emph{optional}) and terminal output. In addition an
\linkS4class{RLum.Results} object is returned containing the
following elements:

\item{summary}{\link{data.frame} summary of all relevant model results.}
\item{data}{\link{data.frame} original input data}
\item{args}{\link{list} used arguments}
\item{call}{\link{call} the function call}
\item{usedDeValues}{\link{data.frame} containing the used values for the calculation}
}
\description{
This function applies the method according to Fuchs & Lang (2001) for
heterogeneously bleached samples with a given coefficient of variation
threshold.
}
\details{
\strong{Used values}

If the coefficient of variation (\code{c[v]}) of the first
two values is larger than the threshold \code{c[v_threshold]}, the first value is
skipped.  Use the \code{startDeValue} argument to define a start value for
calculation (e.g. 2nd or 3rd value).

\strong{Basic steps of the approach}
\enumerate{
\item Estimate natural relative variation of the sample using a dose recovery test
\item Sort the input values ascendantly
\item Calculate a running mean, starting with the lowermost two values and add values iteratively.
\item Stop if the calculated \code{c[v]} exceeds the specified \code{cvThreshold}
}
}
\note{
Please consider the requirements and the constraints of this method
(see Fuchs & Lang, 2001)
}
\section{Function version}{
 0.4.1
}

\examples{
## load example data
data(ExampleData.DeValues, envir = environment())

## calculate De according to Fuchs & Lang (2001)
temp<- calc_FuchsLang2001(ExampleData.DeValues$BT998, cvThreshold = 5)

} 

\section{How to cite}{
Kreutzer, S., Burow, C., 2024. calc_FuchsLang2001(): Apply the model after Fuchs & Lang (2001) to a given De distribution.. Function version 0.4.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2024. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.24. https://CRAN.R-project.org/package=Luminescence
}

\references{
Fuchs, M. & Lang, A., 2001. OSL dating of coarse-grain fluvial
quartz using single-aliquot protocols on sediments from NE Peloponnese,
Greece. In: Quaternary Science Reviews 20, 783-787.

Fuchs, M. & Wagner, G.A., 2003. Recognition of insufficient bleaching by
small aliquots of quartz for reconstructing soil erosion in Greece.
Quaternary Science Reviews 22, 1161-1167.
}
\seealso{
\link{plot}, \link{calc_MinDose}, \link{calc_FiniteMixture}, \link{calc_CentralDose},
\link{calc_CommonDose}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany) \cr
Christoph Burow, University of Cologne (Germany)
, RLum Developer Team}
\keyword{dplot}
