% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{generateVariantTable}
\alias{generateVariantTable}
\title{Make variant table from maf file}
\usage{
generateVariantTable(maf, use_syn = FALSE, extra_cols = c())
}
\arguments{
\item{maf}{The MAF object}

\item{use_syn}{Whether or not to include synonymous variants (default is FALSE, i.e. returns non-synonymous mutations only)}

\item{extra_cols}{Vector of column names to include from the MAF file.  If it's a named vector, the names will be used in the output table.}
}
\value{
A data frame containing the variant information
}
\description{
Make variant table from maf file
}
\examples{
library(MAFDash)
library(maftools)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
variantTable<-generateVariantTable(read.maf(maf))
}
