% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_04_MODALITY_ANALYSIS_1_AssignModality.R
\name{AssignModality}
\alias{AssignModality}
\title{Modality Assignment}
\usage{
AssignModality(
  MarvelObject,
  cell.type.columns,
  cell.type.variables,
  n.cells,
  sigma.sq = 0.001,
  bimodal.adjust,
  seed
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{ComputePSI} function.}

\item{cell.type.columns}{Character string. To indicate which columns in the \code{MarvelObject$SplicePheno} slot to refer to when filtering samples (cells) for analysis.}

\item{cell.type.variables}{List of character string. To indicate which specific variables of the corresponding columns to keep the samples (cells). This should be same length as the \code{cell.type.columns} argument.}

\item{n.cells}{Numeric value. The minimum no. of cells expressing the splicing event for the event to be included for modality assignment.}

\item{sigma.sq}{Numeric value. The variance threshold below which the included/excluded modality will be defined as primary sub-modality, and above which it will be defined as dispersed sub-modality.}

\item{bimodal.adjust}{Logical. When set to \code{TRUE}, MARVEL will identify false bimodal modalities and reassign them as included/excluded modality.}

\item{seed}{Numeric value. Ensure the \code{fitdist} function returns the same values for alpha and beta paramters each time this function is executed using the same random number generator.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new data frame. This data frame is store in \code{$Modality$Results} slot. This data frame contains the modality assignment for each splicing event and is saved into the \code{Modality} slot. \code{modality} column reflects the five main modalities, i.e. included, excluded, bimodal, middle, and multimodal. \code{modality.var} column additional stratifies included and excluded modalities into primary and dispersed sub-modalities. \code{modality.bimodal.adj} column identifies and re-categorizes false bimodals into included or excluded modalities when \code{bimodal.adjust} is set to \code{TRUE}.
}
\description{
\code{AssignModality} assigns modalities to each splicing event for a specified group of cells.
}
\details{
This function assigns modalities to each splicing event for a specified group of cells. The five main modalities are included, excluded, bimodal, middle, and multimodal (inspired by Song (2017)). \code{MARVEL} further stratifies included and excluded modalities into primary and dispersed sub-modalities depending on the variance (dispersion).
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- AssignModality(MarvelObject=marvel,
                         cell.type.columns=c("cell.type"),
                         cell.type.variables=c("iPSC"),
                         n.cells=2,
                         bimodal.adjust=TRUE,
                         seed=1
                         )

# Check output
marvel$Modality$Results
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
