% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_DROPLET_07_ADHOC_PLOT_PCA_1_PlotFeatures.R
\name{PlotValues.PCA.CellGroup.10x}
\alias{PlotValues.PCA.CellGroup.10x}
\title{Annotate reduced dimension space with cell feature}
\usage{
PlotValues.PCA.CellGroup.10x(
  MarvelObject,
  cell.group.list,
  legendtitle = "Cell group",
  alpha = 0.75,
  point.size = 1,
  point.stroke = 0.1,
  point.colors = NULL,
  point.size.legend = 2,
  type
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CheckAlignment.10x} function.}

\item{cell.group.list}{List of character strings. Each element of the list is a vector of cell IDs corresponding to a feature, e.g. cell group. The names of the element will be the cell feature label.}

\item{legendtitle}{Character string. Legend title. Default is \code{"Cell group"}.}

\item{alpha}{Numeric value. Transparency of the data points. Takes any values between 0-1 whereby 0 is totally transparent and 1 is opaque. Default is \code{0.75}.}

\item{point.size}{Numeric value. Size of data points. Default is \code{1}.}

\item{point.stroke}{Numeric value. Outline thickness of data points.  Default is \code{0.1}.}

\item{point.colors}{Vector of character strings. Colors of cell groups and should be same length as \code{cell.group.list}. Default \code{ggplot2} colors are used.}

\item{point.size.legend}{Numeric value. Size of legend keys. Default is \code{2}.}

\item{type}{Character string. Type of reduced dimension space. Options are \code{"umap"} and \code{"tsne"}.}
}
\value{
An object of class S3 with new slot \code{MarvelObject$adhocPlot$PCA$CellGroup}.
}
\description{
Annotates reduced dimension space, e.g., UMAP and tSNE, with cell features such as cell group, donor ID, sample ID, etc.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

# Define cell groups
    # Retrieve sample metadata
    sample.metadata <- marvel.demo.10x$sample.metadata

    # iPSC
    index <- which(sample.metadata$cell.type=="iPSC")
    cell.ids.1 <- sample.metadata[index, "cell.id"]
    length(cell.ids.1)

    # Cardio day 10
    index <- which(sample.metadata$cell.type=="Cardio day 10")
    cell.ids.2 <- sample.metadata[index, "cell.id"]
    length(cell.ids.2)

    # Save into list
    cell.group.list <- list("iPSC"=cell.ids.1,
                            "Cardio d10"=cell.ids.2
                            )

# Plot cell groups
marvel.demo.10x <- PlotValues.PCA.CellGroup.10x(
                            MarvelObject=marvel.demo.10x,
                            cell.group.list=cell.group.list,
                            legendtitle="Cell group",
                            type="tsne"
                            )

# Check output
marvel.demo.10x$adhocPlot$PCA$CellGroup
}
