% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{Beta}
\alias{Beta}
\title{Regression coefficients of MBPLS or MBWCov models}
\usage{
Beta(res, ncomp = res$call$ncomp)
}
\arguments{
\item{res}{An object resulting from \code{\link{MBPLS}} or \code{\link{MBWCov}}.}

\item{ncomp}{The number of components to be considered in the model. By default, all components computed in \code{\link{MBPLS}} or \code{\link{MBWCov}} are considered.}
}
\value{
A matrix of regression coefficients where each row corresponds to a variable in X and each column corresponds to a variable in Y.
}
\description{
Computes regression coefficients from \code{\link{MBPLS}} or \code{\link{MBWCov}}.
}
\examples{
# With MBPLS

data(ham)
X=ham$X
block=ham$block
Y=ham$Y
res.mbpls <- MBPLS(X, Y, block, name.block = names(block))
Beta(res.mbpls)

# With MBWCov

data(ham)
X=ham$X
block=ham$block
Y=ham$Y
res.mbwcov <- MBWCov(X, Y, block, name.block = names(block))
Beta(res.mbwcov)

}
\seealso{
\code{\link{predict.MBPLS}}   \code{\link{predict.MBWCov}}
}
