% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedSum.R
\name{weightedSum}
\alias{weightedSum}
\title{Weighted sum of evaluations of alternatives.}
\usage{
weightedSum(
  performanceTable,
  criteriaWeights,
  alternativesIDs = NULL,
  criteriaIDs = NULL
)
}
\arguments{
\item{performanceTable}{Matrix or data frame containing the performance
table. Each row corresponds to an alternative, and each column to a
criterion. Rows (resp. columns) must be named according to the IDs of the
alternatives (resp. criteria).}

\item{criteriaWeights}{Vector containing the weights of the criteria. The
elements are named according to the IDs of the criteria.}

\item{alternativesIDs}{Vector containing IDs of alternatives, according to
which the performance table should be filtered.}

\item{criteriaIDs}{Vector containing IDs of criteria, according to which the
performance table should be filtered.}
}
\value{
The function returns a vector containing the weighted sum of the
alternatives with respect to the criteria weights.
}
\description{
Computes the weighted sum of the evaluations of alternatives, stored in a
performance table, with respect to a vector of criteria weights.
}
\examples{
alts <- paste0("alt", 1:4)
crit <- paste0("x", 1:3)
performanceTable <- matrix(runif(length(alts)*length(crit)), 
                           nrow=length(alts), ncol=length(crit), 
                           dimnames=list(alts, crit))
weights <- setNames(c(1,2,3), crit)
# Overall
weightedSum(performanceTable, weights)
# Subset of alteratives and criteria
weightedSum(performanceTable, weights, 
            alternativesIDs=c("alt2","alt3"), criteriaIDs=c("x2","x3"))

}
\keyword{methods}
