% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateCauchy.R
\name{estimateCauchy}
\alias{estimateCauchy}
\title{Estimate Cauchy Distribution for MCMCtree}
\usage{
estimateCauchy(minAge, maxAge, phy, monoGroups, scale = 0.2,
  offset = 0.1, estimateScale = TRUE, minProb = 0, maxProb = 0.975,
  plot = FALSE, pdfOutput = "cauchyPlot.pdf", writeMCMCtree = FALSE,
  MCMCtreeName = "cauchyInput.tre")
}
\arguments{
\item{minAge}{vector of minimum age bounds for nodes matching order in monoGroups}

\item{maxAge}{vector of maximum age bounds for nodes matching order in monoGroups}

\item{phy}{fully resolved phylogeny in ape format}

\item{monoGroups}{list  with each element containing species that define a node of interest}

\item{scale}{scale value for cauchy distribution (default = 1.5) (c in PAML manual page 49)}

\item{offset}{offset value for cauchy distribution (default = 50) (p in PAML manual page 49)}

\item{estimateScale}{logical specifying whether to estimate scale with a given shape value (default = TRUE)}

\item{minProb}{probability of left tail (minimum bound) - default to hard minimum (minProb=0)}

\item{maxProb}{probability of right tail (maximum bound. default = 0.975)}

\item{plot}{logical specifying whether to plot to PDF}

\item{pdfOutput}{pdf output file name}

\item{writeMCMCtree}{logical whether to write tree in format that is compatible with MCMCTree to file}

\item{MCMCtreeName}{MCMCtree.output file name}
}
\value{
list containing node estimates for each distribution
\itemize{
 \item{"parameters"}{ estimated parameters for each node}
 \item{"apePhy"}{ phylogeny in ape format with node labels showing node distributions}
 \item{"MCMCtree"}{ phylogeny in MCMCtree format}
 \item{"nodeLabels"}{ node labels in MCMCtreeR format}
}

If plot=TRUE plot of distributions in file 'pdfOutput' written to current working directory

If writeMCMCtree=TRUE tree in MCMCtree format in file "MCMCtreeName" written to current working directory
}
\description{
Estimate the offset and scale paramaters of a soft-tailed cauchy distribution and output trees for MCMCtree input
}
\examples{
data(apeData)
attach(apeData)
monophyleticGroups <- list()
monophyleticGroups[[1]] <- c("human", "chimpanzee", "bonobo", 
"gorilla", "sumatran", "orangutan", "gibbon")
getMRCA(apeTree, c("human", "chimpanzee", "bonobo", "gorilla"))
monophyleticGroups[[2]] <-  tipDes(apeTree, 10)
monophyleticGroups[[3]] <- tipDes(apeTree, 11)
monophyleticGroups[[4]] <- c("sumatran", "orangutan")
minimumTimes <- c("nodeOne"=15, "nodeTwo"=6,
"nodeThree"=8, "nodeFour"=13) / 10
maximumTimes <- c("nodeOne" = 30, "nodeTwo" = 12,
"nodeThree"=12, "nodeFour" = 20) / 10
estimateCauchy(minAge=minimumTimes, maxAge=maximumTimes, 
monoGroups=monophyleticGroups, offset=0.5, phy=apeTree, plot=FALSE)
}
