% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tipDes.R
\name{tipDes}
\alias{tipDes}
\title{Find Descendent Tips From A Common Ancestor}
\usage{
tipDes(phy, node)
}
\arguments{
\item{phy}{user tree in ape format}

\item{node}{one or more nodes from the ape format that designate the crown monophyletic group}
}
\description{
This function finds tip descendants from a common ancestor
}
\details{
If a single node number is supplied the function returns a vector of tip labels. When more than one node number is supplied the function returns a list with each element a vector of tip labels for that node.
}
\examples{
set.seed(1029)
# one node
phy <- rcoal(10)
node <- 13
tipDes(phy, node)
## multiple nodes
node <- c(13,14,15)
tipDes(phy, node)
}
\author{
Mark Puttick
}
\keyword{ancestor}
\keyword{node}
