% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_sdp.R
\name{MFKnockoffs.knocks.solve_sdp}
\alias{MFKnockoffs.knocks.solve_sdp}
\title{Optimization for SDP knockoffs}
\usage{
MFKnockoffs.knocks.solve_sdp(Sigma, gaptol = 1e-06, maxit = 1000)
}
\arguments{
\item{Sigma}{A positive-definite correlation matrix}

\item{gaptol}{Tolerance for duality gap as a fraction of the value of the objective functions (default 1e-6)}

\item{maxit}{The maximum number of iterations for the solver (default: 1000)}
}
\value{
The solution \eqn{s} to the semidefinite programming problem defined above
}
\description{
Solves the optimization problem needed to create SDP knockoffs using an interior point method
}
\details{
Solves the semidefinite programming problem:

  \deqn{ \mathrm{maximize}      \; \mathrm{sum}(s) \quad
          \mathrm{subject} \; \mathrm{to}    0 <= s <= 1, \;
                                 2\Sigma - \mathrm{diag}(s) >= 0}

If the matrix Sigma supplied by the user is a non-scaled covariance matrix 
(i.e. its diagonal entries are not all equal to 1), then the appropriate scaling is applied before
solving the SDP defined above. The result is then scaled back before being returned, as to match 
the original scaling of the covariance matrix supplied by the user.
}
\seealso{
Other Optimize knockoffs: \code{\link{MFKnockoffs.knocks.solve_asdp}},
  \code{\link{MFKnockoffs.knocks.solve_equi}}
}
