% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/univPCA.R
\name{PACE}
\alias{PACE}
\title{Univariate functional principal component analysis by smoothed covariance}
\usage{
PACE(funDataObject, predData = NULL, nbasis = 10, pve = 0.99,
  npc = NULL, makePD = FALSE)
}
\arguments{
\item{funDataObject}{An object of class \code{\link[funData]{funData}}
containing the functional data observed, for which the functional principal
component analysis is calculated.}

\item{predData}{An object of class \code{\link[funData]{funData}}, for which
estimated trajectories based on a truncated Karhunen-Loeve representation
should be estimated. Defaults to \code{NULL}, which implies prediction for
the given data.}

\item{nbasis}{An integer, representing the number of  B-spline basis
functions used for estimation of the mean function and bivariate smoothing
of the covariance surface. Defaults to \code{10} (cf.
\code{\link[refund]{fpca.sc}}).}

\item{pve}{A numeric value between 0 and 1, the proportion of variance
explained: used to choose the number of principal components. Defaults to
\code{0.99} (cf. \code{\link[refund]{fpca.sc}}).}

\item{npc}{An integer, giving a prespecified value for the number of
principal components. Defaults to \code{NULL}. If given, this overrides
\code{pve} (cf. \code{\link[refund]{fpca.sc}}).}

\item{makePD}{Logical: should positive definiteness be enforced for the
  covariance surface estimate? Defaults to \code{FALSE} (cf.
  \code{\link[refund]{fpca.sc}}).}
}
\value{
\item{mu}{A \code{\link[funData]{funData}} object with one
  observation, corresponding to the mean function.} \item{values}{A vector
  containing the estimated eigenvalues.} \item{functions}{A
  \code{\link[funData]{funData}} object containing the estimated functional
  principal components.} \item{scores}{An matrix of estimated scores for the
  observations in \code{funDataObject}. Each row corresponds to the scores of
  one observation.} \item{fit}{A \code{\link[funData]{funData}} object
  containing the estimated trajectories based on the truncated Karhunen-Loeve
  representation and the estimated scores and functional principal components
  for \code{predData} (if this is not \code{NULL}) or \code{funDataObject}
  (if \code{predData} is \code{NULL}).} \item{npc}{The number of functional
  principal components: either the supplied \code{npc}, or the minimum number
  of basis functions needed to explain proportion \code{pve} of the variance
  in the observed curves (cf. \code{\link[refund]{fpca.sc}}).}
  \item{sigma2}{The estimated measurement error variance (cf.
  \code{\link[refund]{fpca.sc}}).}
}
\description{
This function calculates a univariate functional principal components
analysis by smoothed covariance based on code from
\code{\link[refund]{fpca.sc}} (package \pkg{refund}).
}
\section{Warning}{
 This function works only for univariate functional data
  observed on one-dimensional domains.
}
\examples{
\donttest{
  oldPar <- par(no.readonly = TRUE)

  # simulate data
  sim <- simFunData(argvals = seq(-1,1,0.01), M = 5, eFunType = "Poly",
                    eValType = "exponential", N = 100)

  # calculate univariate FPCA
  pca <- PACE(sim$simData, npc = 5)

  # Plot the results
  par(mfrow = c(1,2))
  plot(sim$trueFuns, lwd = 2, main = "Eigenfunctions")
  # flip estimated functions for correct signs
  plot(flipFuns(sim$trueFuns,pca$functions), lty = 2, add = TRUE)
  legend("bottomright", c("True", "Estimate"), lwd = c(2,1), lty = c(1,2))

  plot(sim$simData, lwd = 2, main = "Some Observations", obs = 1:7)
  plot(pca$fit, lty = 2, obs = 1:7, add = TRUE) # estimates are almost equal to true values
  legend("bottomright", c("True", "Estimate"), lwd = c(2,1), lty = c(1,2))

  par(oldPar)
}
}
\seealso{
\code{\link[funData]{funData}}, \code{\link[refund]{fpca.sc}},
  \code{\link{fpcaBasis}}, \code{\link{univDecomp}}
}

